/*
 * Decompiled with CFR 0.152.
 */
package one.harmony.common;

import java.io.IOException;
import java.util.Properties;

public class Config {
    public static final String DEFAULT_URL = "http://localhost:9500/";
    public static final String DEFAULT_DIR_NAME = ".hmy_java";
    public static final String DEFAULT_ACCOUNT_ALIAS_DIR_NAME = "accounts-keys";
    public static final String DEFAULT_PASSPHRASE = "harmony-one";
    public static final int SECP256K1_PK_BYTES_LENGTH = 32;
    public static String node = "http://localhost:9500/";
    public static String keystore = ".hmy_java";
    public static String accounts = "accounts-keys";
    public static String passphrase = "harmony-one";

    public static String readNode() throws IOException {
        return Config.loadProperties().getProperty("node");
    }

    public static String readDirName() throws IOException {
        return Config.loadProperties().getProperty("keystore.dir");
    }

    public static String readAccountAliasDirName() throws IOException {
        return Config.loadProperties().getProperty("accounts.dir");
    }

    public static String readPassphrase() throws IOException {
        return Config.loadProperties().getProperty("passphrase");
    }

    private static Properties loadProperties() throws IOException {
        Properties properties = new Properties();
        properties.load(Config.class.getResourceAsStream("/hmy-config.properties"));
        return properties;
    }

    static {
        try {
            String input = Config.readNode();
            if (input != null) {
                node = input;
            }
            if ((input = Config.readDirName()) != null) {
                keystore = input;
            }
            if ((input = Config.readAccountAliasDirName()) != null) {
                accounts = input;
            }
            if ((input = Config.readPassphrase()) != null) {
                passphrase = input;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

