/*
 * Decompiled with CFR 0.152.
 */
package one.harmony.transaction;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Base64;
import java.util.List;
import one.harmony.account.Account;
import one.harmony.account.Address;
import one.harmony.rpc.HmyResponse;
import one.harmony.rpc.RPC;
import one.harmony.rpc.ShardingStructure;
import one.harmony.sharding.Sharding;
import one.harmony.transaction.Transaction;
import one.harmony.transaction.TxParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.utils.Numeric;

public class Handler {
    private static final Logger log = LoggerFactory.getLogger(Handler.class);
    private Transaction transaction;
    private TxParams txParams;
    private Account sender;
    private String url;

    public Handler(Account account, String url) {
        this.sender = account;
        this.txParams = new TxParams();
        this.url = url;
    }

    private void setShardIDs(int fromShard, int toShard) throws Exception {
        List<ShardingStructure.RPCRoutes> shards = Sharding.getShardingStructure();
        if (!Sharding.validateShardIDs(fromShard, toShard, shards.size())) {
            throw new IllegalArgumentException("Invalid shard ids passed");
        }
        this.txParams.setFromShard(fromShard);
        this.txParams.setToShard(toShard);
    }

    private long computeIntrinsicGas(byte[] data, boolean contractCreation, boolean homestead) throws Exception {
        long gas = contractCreation && homestead ? 53000L : 21000L;
        if (data.length > 0) {
            long nz = 0L;
            for (byte b : data) {
                if (b == 0) continue;
                ++nz;
            }
            if ((Long.MAX_VALUE - gas) / 68L < nz) {
                throw new Exception("out of gas");
            }
            long z = (long)data.length - nz;
            if ((Long.MAX_VALUE - (gas += nz * 68L)) / 68L < z) {
                throw new Exception("out of gas");
            }
            gas += z * 68L;
        }
        return gas;
    }

    private void setIntrinsicGas(String payload) throws Exception {
        byte[] data = Base64.getDecoder().decode(payload);
        long gas = this.computeIntrinsicGas(data, false, true);
        this.txParams.setGas(gas);
    }

    private void setAmount(double amount) {
        BigInteger nano = BigInteger.TEN.pow(9);
        double nanoAmount = nano.doubleValue() * amount;
        BigInteger amt = new BigDecimal(nanoAmount).toBigInteger().multiply(nano);
        this.txParams.setTransferAmount(amt.doubleValue());
    }

    private void verifyBalance(double amount) throws Exception {
        HmyResponse response = (HmyResponse)new RPC(this.url).getBalance(this.sender.getAddress().getOneAddr()).send();
        if (response.hasError()) {
            throw new Exception(response.getError().getMessage());
        }
        BigInteger nano = BigInteger.TEN.pow(9);
        BigInteger balance = Numeric.toBigInt((String)((String)response.getResult()));
        double nanoAmount = nano.doubleValue() * amount;
        BigInteger transfer = new BigDecimal(nanoAmount).toBigInteger();
        double bln = balance.divide(nano).doubleValue();
        double tns = transfer.divide(nano).doubleValue();
        if (tns > bln) {
            throw new Exception(String.format("current balance of %lf is not enough for the requested transfer %lf", bln, tns));
        }
    }

    private void setReceiver(String receiver) {
        if (Address.isOneAddr(receiver)) {
            this.txParams.setReceiver(Address.parseBech32(receiver));
        } else {
            this.txParams.setReceiver(receiver);
        }
    }

    private void setGasPrice() {
        this.txParams.setGasPrice(1L);
    }

    private void setNextNonce() throws Exception {
        RPC rpc = new RPC(this.url);
        HmyResponse response = (HmyResponse)rpc.getTransactionCount(this.sender.getAddress().getHexAddr()).send();
        if (response.hasError()) {
            throw new Exception();
        }
        BigInteger nonce = Numeric.toBigInt((String)((String)response.getResult()));
        this.txParams.setNonce(nonce.longValue());
    }

    private void setNewTransactionWithDataAndGas(String payload, double amount, long gasPrice) {
        BigInteger nano = BigInteger.TEN.pow(9);
        double nanoAmount = nano.doubleValue() * amount;
        BigInteger amt = new BigDecimal(nanoAmount).toBigInteger().multiply(nano);
        BigInteger gas = BigInteger.valueOf(gasPrice).multiply(nano);
        this.transaction = new Transaction(this.txParams.getNonce(), this.txParams.getReceiver(), this.txParams.getFromShard(), this.txParams.getToShard(), amt, this.txParams.getGas(), gas, payload.getBytes());
    }

    private void signAndPrepareTxEncodedForSending(int chainId) throws JsonProcessingException {
        Transaction signedTransaction = this.transaction.sign(chainId, this.sender.getCredentials());
        log.info(String.format("signed transaction with chainId %d", chainId));
        ObjectMapper mapper = new ObjectMapper();
        log.info(mapper.writeValueAsString((Object)signedTransaction));
    }

    private void sendSignedTx() throws Exception {
        HmyResponse response = (HmyResponse)new RPC(this.url).sendRawTransaction(new String(this.transaction.getRawHash())).send();
        if (response.hasError()) {
            throw new Exception(response.getError().getMessage());
        }
        this.transaction.setTxHash((String)response.getResult());
    }

    private void txConfirm(int waitToConfirmTime) throws Exception {
        if (waitToConfirmTime > 0) {
            int start = waitToConfirmTime;
            while (true) {
                if (start < 0) {
                    return;
                }
                HmyResponse response = (HmyResponse)new RPC(this.url).getTransactionReceipt(this.transaction.getTxHash()).send();
                if (response.hasError()) {
                    throw new Exception(response.getError().getMessage());
                }
                if (response.getResult() != null) {
                    log.info("received transaction confirmation, ", response.getResult());
                    return;
                }
                Thread.sleep(2000L);
                start -= 2;
            }
        }
    }

    public String execute(int chainId, String receiver, String payload, double amount, long gasPrice, int fromShard, int toShard, boolean dryRun, int waitToConfirmTime) throws Exception {
        this.setShardIDs(fromShard, toShard);
        this.setIntrinsicGas(payload);
        this.setAmount(amount);
        this.verifyBalance(amount);
        this.setReceiver(receiver);
        this.setGasPrice();
        this.setNextNonce();
        this.setNewTransactionWithDataAndGas(payload, amount, gasPrice);
        this.signAndPrepareTxEncodedForSending(chainId);
        if (!dryRun) {
            this.sendSignedTx();
            this.txConfirm(waitToConfirmTime);
        }
        return this.transaction.getTxHash();
    }
}

