/*
 * Decompiled with CFR 0.152.
 */
package one.harmony.rpc;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.core.Response;

public class ShardingStructure
extends Response<List<RPCRoutes>> {
    @JsonDeserialize(using=RPCRoutesDeserialiser.class)
    public void setResult(List<RPCRoutes> structure) {
        super.setResult(structure);
    }

    public List<RPCRoutes> getShardingResponse() {
        return (List)this.getResult();
    }

    public static class RPCRoutesDeserialiser
    extends JsonDeserializer<List<RPCRoutes>> {
        private ObjectReader objectReader = ObjectMapperFactory.getObjectReader();

        public List<RPCRoutes> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            p.nextToken();
            ArrayList<RPCRoutes> rpcRoutes = new ArrayList<RPCRoutes>();
            Iterator rpcRoutesIter = this.objectReader.readValues(p, RPCRoutes.class);
            while (rpcRoutesIter.hasNext()) {
                rpcRoutes.add((RPCRoutes)rpcRoutesIter.next());
            }
            return rpcRoutes;
        }
    }

    public static class RPCRoutes {
        private boolean current;
        private String http;
        private int shardID;
        private String ws;

        public RPCRoutes() {
        }

        public RPCRoutes(boolean current, String http, int shardID, String ws) {
            this.current = current;
            this.http = http;
            this.shardID = shardID;
            this.ws = ws;
        }

        public boolean isCurrent() {
            return this.current;
        }

        public void setCurrent(boolean current) {
            this.current = current;
        }

        public String getHttp() {
            return this.http;
        }

        public void setHttp(String http) {
            this.http = http;
        }

        public int getShardID() {
            return this.shardID;
        }

        public void setShardID(int shardID) {
            this.shardID = shardID;
        }

        public String getWs() {
            return this.ws;
        }

        public void setWs(String ws) {
            this.ws = ws;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            sb.append("\"current\":");
            sb.append(this.current);
            sb.append(",");
            sb.append("\"http\":\"");
            sb.append(this.http);
            sb.append("\",");
            sb.append("\"shardID\":");
            sb.append(this.shardID);
            sb.append(",");
            sb.append("\"ws\":\"");
            sb.append(this.ws);
            sb.append("\"}");
            return sb.toString();
        }
    }
}

