/*
 * Decompiled with CFR 0.152.
 */
package one.harmony.cmd;

import one.harmony.account.HistoryParams;
import one.harmony.common.Config;
import one.harmony.rpc.AccountTransactionsResponse;
import one.harmony.rpc.HmyResponse;
import one.harmony.rpc.RPC;

public class Blockchain {
    public static String getProtocolVersion() throws Exception {
        RPC rpc = new RPC(Config.node);
        HmyResponse response = (HmyResponse)rpc.getProtocolVersion().send();
        if (response.hasError()) {
            throw new Exception("failed to fetch protocol version");
        }
        return (String)response.getResult();
    }

    public static String getAccountTransactions(String node, HistoryParams params) throws Exception {
        AccountTransactionsResponse response = (AccountTransactionsResponse)new RPC(node).getTransactionsHistory(params).send();
        if (response.hasError()) {
            throw new Exception(response.getError().getMessage());
        }
        return ((AccountTransactionsResponse.AccountTransactions)response.getResult()).toString();
    }

    public static String getAccountTransactions(HistoryParams params) throws Exception {
        return Blockchain.getAccountTransactions(Config.node, params);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(Blockchain.getProtocolVersion());
    }
}

