/*
 * Decompiled with CFR 0.152.
 */
package one.harmony.rpc;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.core.Response;

public class AccountTransactionsResponse
extends Response<AccountTransactions> {
    @JsonDeserialize(using=AccountTxsDeserialiser.class)
    public void setResult(AccountTransactions txs) {
        super.setResult((Object)txs);
    }

    public static class AccountTxDeserialiser
    extends JsonDeserializer<List<AccountTransaction>> {
        private ObjectReader objectReader = ObjectMapperFactory.getObjectReader();

        public List<AccountTransaction> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ArrayList<AccountTransaction> txs;
            block3: {
                JsonToken nextToken;
                block2: {
                    nextToken = p.nextToken();
                    txs = new ArrayList<AccountTransaction>();
                    if (nextToken != JsonToken.START_OBJECT) break block2;
                    Iterator txsIter = this.objectReader.readValues(p, AccountTransaction.class);
                    while (txsIter.hasNext()) {
                        txs.add((AccountTransaction)txsIter.next());
                    }
                    break block3;
                }
                if (nextToken != JsonToken.VALUE_STRING) break block3;
                Iterator txsIter = this.objectReader.readValues(p, String.class);
                while (txsIter.hasNext()) {
                    String txHash = (String)txsIter.next();
                    AccountTransaction accountTx = new AccountTransaction();
                    accountTx.setHash(txHash);
                    txs.add(accountTx);
                }
            }
            return txs;
        }
    }

    public static class AccountTxsDeserialiser
    extends JsonDeserializer<AccountTransactions> {
        private ObjectReader objectReader = ObjectMapperFactory.getObjectReader();

        public AccountTransactions deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (p.getCurrentToken() != JsonToken.VALUE_NULL) {
                return (AccountTransactions)this.objectReader.readValue(p, AccountTransactions.class);
            }
            return null;
        }
    }

    public static class AccountTransaction {
        private String blockHash;
        private String blockNumber;
        private String from;
        private String gas;
        private String gasPrice;
        private String hash;
        private String input;
        private String nonce;
        private String r;
        private String s;
        private int shardID;
        private String timestamp;
        private String to;
        private int toShardID;
        private String transactionIndex;
        private String v;
        private String value;

        public String getBlockHash() {
            return this.blockHash;
        }

        public void setBlockHash(String blockHash) {
            this.blockHash = blockHash;
        }

        public String getBlockNumber() {
            return this.blockNumber;
        }

        public void setBlockNumber(String blockNumber) {
            this.blockNumber = blockNumber;
        }

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getGas() {
            return this.gas;
        }

        public void setGas(String gas) {
            this.gas = gas;
        }

        public String getGasPrice() {
            return this.gasPrice;
        }

        public void setGasPrice(String gasPrice) {
            this.gasPrice = gasPrice;
        }

        public String getHash() {
            return this.hash;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public String getInput() {
            return this.input;
        }

        public void setInput(String input) {
            this.input = input;
        }

        public String getNonce() {
            return this.nonce;
        }

        public void setNonce(String nonce) {
            this.nonce = nonce;
        }

        public String getR() {
            return this.r;
        }

        public void setR(String r) {
            this.r = r;
        }

        public String getS() {
            return this.s;
        }

        public void setS(String s) {
            this.s = s;
        }

        public int getShardID() {
            return this.shardID;
        }

        public void setShardID(int shardID) {
            this.shardID = shardID;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public String getTo() {
            return this.to;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public int getToShardID() {
            return this.toShardID;
        }

        public void setToShardID(int toShardID) {
            this.toShardID = toShardID;
        }

        public String getTransactionIndex() {
            return this.transactionIndex;
        }

        public void setTransactionIndex(String tansactionIndex) {
            this.transactionIndex = tansactionIndex;
        }

        public String getV() {
            return this.v;
        }

        public void setV(String v) {
            this.v = v;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.blockHash == null) {
                sb.append("\"");
                sb.append(this.getHash());
                sb.append("\"");
            } else {
                sb.append("{");
                Field[] fields = this.getClass().getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field f = fields[i];
                    sb.append('\n');
                    sb.append("\"");
                    sb.append(f.getName());
                    sb.append("\"");
                    sb.append(':');
                    try {
                        Object field = f.get(this);
                        if (field instanceof Integer) {
                            sb.append((Integer)field);
                        } else {
                            sb.append("\"");
                            sb.append(field);
                            sb.append("\"");
                        }
                        if (i >= fields.length - 1) continue;
                        sb.append(',');
                        continue;
                    }
                    catch (IllegalAccessException ex) {
                        ex.printStackTrace();
                    }
                }
                sb.append('\n');
                sb.append('}');
            }
            return sb.toString();
        }
    }

    public static class AccountTransactions {
        private List<AccountTransaction> txs;

        public List<AccountTransaction> getTxs() {
            return this.txs;
        }

        @JsonDeserialize(using=AccountTxDeserialiser.class)
        public void setTransactions(List<AccountTransaction> txs) {
            this.txs = txs;
        }

        public void addTx(AccountTransaction tx) {
            this.txs.add(tx);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.txs.size() == 0) {
                return sb.toString();
            }
            sb.append("[\n");
            for (int i = 0; i < this.txs.size(); ++i) {
                sb.append(this.txs.get(i).toString());
                if (i < this.txs.size() - 1) {
                    sb.append(',');
                }
                sb.append('\n');
            }
            sb.append(']');
            return sb.toString();
        }
    }
}

