/*
 * Decompiled with CFR 0.152.
 */
package one.harmony.transaction;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import one.harmony.account.Account;
import one.harmony.account.Address;
import one.harmony.keys.Store;
import one.harmony.rpc.HmyResponse;
import one.harmony.rpc.RPC;
import one.harmony.rpc.ShardingStructure;
import one.harmony.rpc.TransactionReceiptResponse;
import one.harmony.sharding.Sharding;
import one.harmony.transaction.CallArgs;
import one.harmony.transaction.Transaction;
import one.harmony.transaction.TxParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Wallet;
import org.web3j.crypto.WalletFile;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.utils.Numeric;

public class Handler {
    private static final Logger log = LoggerFactory.getLogger(Handler.class);
    private static final BigInteger NANO = BigInteger.TEN.pow(9);
    private static final BigInteger ONE = NANO.multiply(NANO);
    private static final BigDecimal DECIMAL_ONE = new BigDecimal(ONE);
    private static final int DEFAULT_WAIT_TIME = 40;
    private static final long DEFAULT_NONCE = -1L;
    private static final long DEFAULT_GAS = 21000L;
    private static final String DEFAULT_FROM = "0x0000000000000000000000000000000000000000";
    private Transaction transaction;
    private TxParams txParams;
    private Account sender;
    private String from;
    private String url;
    private RPC rpc;
    private int chainID;

    public Handler(Account account, String url) {
        this.sender = account;
        this.txParams = new TxParams();
        this.url = url;
        this.rpc = new RPC(this.url);
    }

    public Handler(String from, String passphrase, String node, int chainID) throws Exception {
        Account account;
        this.from = from;
        this.txParams = new TxParams();
        if (node != null) {
            this.url = node;
        } else {
            List<ShardingStructure.RPCRoutes> shards = Sharding.getShardingStructure();
            this.url = Sharding.getHandlerFor(shards, 0);
        }
        this.rpc = new RPC(this.url);
        String accountName = Store.getAccountNameFromAddress(from);
        boolean isHex = false;
        Address address = new Address(from, isHex);
        WalletFile walletFile = Store.extractWalletFileFromAddress(from);
        Credentials credentials = Credentials.create((ECKeyPair)Wallet.decrypt((String)passphrase, (WalletFile)walletFile));
        this.sender = account = new Account(accountName, address, credentials, walletFile);
        this.chainID = chainID;
    }

    public Handler(String node, int chainID) throws Exception {
        this.txParams = new TxParams();
        if (node != null) {
            this.url = node;
        } else {
            List<ShardingStructure.RPCRoutes> shards = Sharding.getShardingStructure();
            this.url = Sharding.getHandlerFor(shards, 0);
        }
        this.rpc = new RPC(this.url);
        this.chainID = chainID;
    }

    public void setChain(int chainID) {
        this.chainID = chainID;
    }

    private void setShardIDs(int fromShard, int toShard) throws Exception {
        List<ShardingStructure.RPCRoutes> shards = Sharding.getShardingStructure();
        if (!Sharding.validateShardIDs(fromShard, toShard, shards.size())) {
            throw new IllegalArgumentException("Invalid shard ids passed");
        }
        this.txParams.setFromShard(fromShard);
        this.txParams.setToShard(toShard);
    }

    private long computeIntrinsicGas(byte[] data, boolean contractCreation, boolean homestead) throws Exception {
        long gas = contractCreation && homestead ? 53000L : 21000L;
        if (data.length > 0) {
            long nz = 0L;
            for (byte b : data) {
                if (b == 0) continue;
                ++nz;
            }
            if ((Long.MAX_VALUE - gas) / 68L < nz) {
                throw new Exception("out of gas");
            }
            long z = (long)data.length - nz;
            if ((Long.MAX_VALUE - (gas += nz * 68L)) / 4L < z) {
                throw new Exception("out of gas");
            }
            gas += z * 4L;
        }
        return gas;
    }

    private void setIntrinsicGas(String payload, long provided) throws Exception {
        byte[] data = payload.getBytes();
        long gas = Math.max(this.computeIntrinsicGas(data, false, true), provided);
        this.txParams.setGas(gas);
    }

    private void setAmount(String amount) {
        this.txParams.setTransferAmount(amount);
    }

    private void verifyBalance(String amount) throws Exception {
        HmyResponse response;
        if (this.rpc == null) {
            this.rpc = new RPC(this.url);
        }
        if ((response = (HmyResponse)this.rpc.getBalance(this.sender.getAddress().getOneAddr()).send()).hasError()) {
            throw new Exception(response.getError().getMessage());
        }
        BigInteger balance = Numeric.toBigInt((String)((String)response.getResult()));
        BigDecimal amt = new BigDecimal(amount).multiply(DECIMAL_ONE);
        BigInteger transfer = amt.toBigInteger();
        double tns = transfer.divide(ONE).doubleValue();
        double bln = balance.divide(ONE).doubleValue();
        if (transfer.compareTo(balance) > 0) {
            throw new Exception(String.format("current balance of %lf is not enough for the requested transfer %lf", bln, tns));
        }
    }

    private void setReceiver(String receiver) {
        if (receiver == null) {
            this.txParams.setReceiver(receiver);
            return;
        }
        if (Address.isOneAddr(receiver)) {
            this.txParams.setReceiver(Address.parseBech32(receiver));
        } else {
            this.txParams.setReceiver(receiver);
        }
    }

    private void setGasPrice() {
        this.txParams.setGasPrice(1L);
    }

    private void setNextNonce() throws Exception {
        HmyResponse response;
        if (this.rpc == null) {
            this.rpc = new RPC(this.url);
        }
        if ((response = (HmyResponse)this.rpc.getTransactionCount(this.sender.getAddress().getHexAddr()).send()).hasError()) {
            throw new Exception();
        }
        BigInteger nonce = Numeric.toBigInt((String)((String)response.getResult()));
        this.txParams.setNonce(nonce.longValue());
    }

    private void setNewTransactionWithDataAndGas(long nonce, String payload, boolean isHex, String amount, long gasPrice) throws Exception {
        BigInteger amt = new BigDecimal(amount).multiply(DECIMAL_ONE).toBigInteger();
        BigInteger gas = BigInteger.valueOf(gasPrice).multiply(NANO);
        long nextNonce = this.txParams.getNonce();
        if (nonce != -1L) {
            nextNonce = nonce;
        }
        byte[] data = isHex ? Numeric.hexStringToByteArray((String)payload) : payload.getBytes();
        this.transaction = new Transaction(this.getFromAddress(), nextNonce, this.txParams.getReceiver(), this.txParams.getFromShard(), this.txParams.getToShard(), amt, this.txParams.getGas(), gas, data);
    }

    private void signAndPrepareTxEncodedForSending(int chainId) throws JsonProcessingException {
        Transaction signedTransaction = this.transaction.sign(chainId, this.sender.getCredentials());
        log.info(String.format("signed transaction with chainId %d", chainId));
        ObjectMapper mapper = new ObjectMapper();
        log.info(mapper.writeValueAsString((Object)signedTransaction));
    }

    private void sendSignedTx() throws Exception {
        HmyResponse response;
        if (this.rpc == null) {
            this.rpc = new RPC(this.url);
        }
        if ((response = (HmyResponse)this.rpc.sendRawTransaction(new String(this.transaction.getRawHash())).send()).hasError()) {
            throw new Exception(response.getError().getMessage());
        }
        this.transaction.setTxHash((String)response.getResult());
    }

    private TransactionReceipt txConfirm(int waitToConfirmTime) throws Exception {
        if (this.rpc == null) {
            this.rpc = new RPC(this.url);
        }
        if (waitToConfirmTime > 0) {
            int start = waitToConfirmTime;
            while (true) {
                if (start < 0) {
                    log.error("could not fetch receipt for transaction with hash: %s", (Object)this.transaction.getTxHash());
                    return null;
                }
                TransactionReceiptResponse response = (TransactionReceiptResponse)this.rpc.getTransactionReceipt(this.transaction.getTxHash()).send();
                if (response.hasError()) {
                    throw new Exception(response.getError().getMessage());
                }
                if (response.getReceipt() != null) {
                    log.info(String.format("received transaction confirmation: %s", response.getReceipt()));
                    return response.getReceipt();
                }
                Thread.sleep(2000L);
                start -= 2;
            }
        }
        return null;
    }

    private String getFromAddress() throws Exception {
        if (this.sender != null) {
            return this.sender.getAddress().getHexAddr();
        }
        if (this.from != null) {
            return new Address(this.from, false).getHexAddr();
        }
        return DEFAULT_FROM;
    }

    public HmyResponse getCode(String contractAddress, DefaultBlockParameter defaultBlockParameter) throws IOException {
        return (HmyResponse)this.rpc.getCode(contractAddress, defaultBlockParameter).send();
    }

    public String call(String to, String data, DefaultBlockParameter defaultBlockParameter, BigInteger gasLimit) throws Exception {
        CallArgs args = new CallArgs();
        args.from = this.getFromAddress();
        args.to = to;
        args.data = data;
        long gas = Math.max(this.computeIntrinsicGas(data.getBytes(), false, true), gasLimit.longValue());
        args.gas = Numeric.encodeQuantity((BigInteger)BigInteger.valueOf(gas));
        BigInteger gasPrice = BigInteger.valueOf(1L).multiply(NANO);
        args.gasPrice = Numeric.encodeQuantity((BigInteger)gasPrice);
        args.value = Numeric.encodeQuantity((BigInteger)BigInteger.ZERO);
        HmyResponse response = (HmyResponse)this.rpc.call(args, defaultBlockParameter).send();
        if (response.hasError()) {
            throw new Exception(response.getError().getMessage());
        }
        return (String)response.getResult();
    }

    public TransactionReceipt send(String to, String data, BigInteger value, BigInteger gasPrice, BigInteger gasLimit, boolean constructor) throws Exception {
        String amount = value.toString();
        this.setShardIDs(0, 0);
        this.setIntrinsicGas(data, gasLimit.longValue());
        this.setAmount(amount);
        this.verifyBalance(amount);
        this.setReceiver(to);
        this.setGasPrice();
        this.setNextNonce();
        this.setNewTransactionWithDataAndGas(-1L, data, true, amount, gasPrice.longValue());
        this.signAndPrepareTxEncodedForSending(this.chainID);
        this.sendSignedTx();
        return this.txConfirm(40);
    }

    public String execute(int chainId, long nonce, String receiver, String payload, String amount, long gasPrice, int fromShard, int toShard, boolean dryRun, int waitToConfirmTime) throws Exception {
        this.setShardIDs(fromShard, toShard);
        this.setIntrinsicGas(payload, 21000L);
        this.setAmount(amount);
        this.verifyBalance(amount);
        this.setReceiver(receiver);
        this.setGasPrice();
        this.setNextNonce();
        this.setNewTransactionWithDataAndGas(nonce, payload, false, amount, gasPrice);
        this.signAndPrepareTxEncodedForSending(chainId);
        if (!dryRun) {
            this.sendSignedTx();
            this.txConfirm(waitToConfirmTime);
        }
        return this.transaction.getTxHash();
    }
}

