/*
 * Decompiled with CFR 0.152.
 */
package one.harmony.cmd;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Map;
import one.harmony.account.Address;
import one.harmony.common.Config;
import one.harmony.keys.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.crypto.CipherException;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.MnemonicUtils;
import org.web3j.crypto.Wallet;
import org.web3j.crypto.WalletFile;
import org.web3j.crypto.WalletUtils;

public class Keys {
    private static final Logger log = LoggerFactory.getLogger(Keys.class);

    private static String generateMnemonic() {
        byte[] initialEntropy = new byte[32];
        new SecureRandom().nextBytes(initialEntropy);
        return MnemonicUtils.generateMnemonic((byte[])initialEntropy);
    }

    public static String addKey(String accountName, String passphrase, String mnemonic) throws CipherException, IllegalArgumentException, IOException {
        if (Store.doesNamedAccountExists(accountName)) {
            throw new IllegalArgumentException("Account already exists by name: " + accountName);
        }
        if (!MnemonicUtils.validateMnemonic((String)mnemonic)) {
            throw new IllegalArgumentException("Invalid mnemonic");
        }
        byte[] seed = MnemonicUtils.generateSeed((String)mnemonic, (String)passphrase);
        ECKeyPair ecKeyPair = ECKeyPair.create((byte[])Hash.sha256((byte[])seed));
        Credentials credentials = Credentials.create((ECKeyPair)ecKeyPair);
        String address = credentials.getAddress();
        String oneAddress = Address.toBech32(address);
        Store.generateWalletFile(accountName, passphrase, ecKeyPair);
        return oneAddress;
    }

    public static String addKey(String accountName, String passphrase) throws CipherException, IllegalArgumentException, IOException {
        String mnemonic = Keys.generateMnemonic();
        log.info("**Important** write this seed phrase in a safe place, it is the only way to recover your account if you ever forget your password", (Object)mnemonic);
        return Keys.addKey(accountName, passphrase, mnemonic);
    }

    public static String addKey(String accountName) throws CipherException, IllegalArgumentException, IOException {
        String mnemonic = Keys.generateMnemonic();
        log.info("**Important** write this seed phrase in a safe place, it is the only way to recover your account if you ever forget your password");
        log.info(mnemonic);
        return Keys.addKey(accountName, Config.passphrase, mnemonic);
    }

    public static String importKeyStore(String keyFilePath, String accountName) throws CipherException, IllegalArgumentException, IOException {
        return Keys.importKeyStore(keyFilePath, accountName, Config.passphrase);
    }

    public static String importKeyStore(String keyFilePath, String accountName, String passphrase) throws CipherException, IllegalArgumentException, IOException {
        if (Store.doesNamedAccountExists(accountName)) {
            throw new IllegalArgumentException("Account name exists");
        }
        Credentials credentials = WalletUtils.loadCredentials((String)passphrase, (String)keyFilePath);
        String address = credentials.getAddress();
        String oneAddress = Address.toBech32(address);
        String searched = Store.searchForAccount(oneAddress);
        if (searched != "") {
            throw new IllegalArgumentException("Account name for the private key exists: " + searched);
        }
        Store.generateWalletFile(accountName, passphrase, credentials.getEcKeyPair());
        return oneAddress;
    }

    public static String importPrivateKey(String secp256k1PRV, String accountName, String passphrase) throws CipherException, IllegalArgumentException, IOException {
        if (Store.doesNamedAccountExists(accountName)) {
            throw new IllegalArgumentException("Account name exists");
        }
        ECKeyPair ecKeyPair = ECKeyPair.create((BigInteger)new BigInteger(secp256k1PRV, 16));
        Credentials credentials = Credentials.create((ECKeyPair)ecKeyPair);
        String address = credentials.getAddress();
        String oneAddress = Address.toBech32(address);
        try {
            String searched = Store.searchForAccount(oneAddress);
            if (searched != "") {
                throw new IllegalArgumentException("Account name for the private key exists: " + searched);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Store.generateWalletFile(accountName, passphrase, ecKeyPair);
        return oneAddress;
    }

    public static String importPrivateKey(String secp256k1PRV, String accountName) throws CipherException, IllegalArgumentException, IOException {
        return Keys.importPrivateKey(secp256k1PRV, accountName, Config.passphrase);
    }

    public static String exportPrivateKeyFromAddress(String oneAddress, String passphrase) throws CipherException, JsonParseException, JsonMappingException, IOException {
        WalletFile walletFile = Store.extractWalletFileFromAddress(oneAddress);
        Credentials credentials = Credentials.create((ECKeyPair)Wallet.decrypt((String)passphrase, (WalletFile)walletFile));
        return credentials.getEcKeyPair().getPrivateKey().toString(16);
    }

    public static String exportPrivateKeyFromAddress(String oneAddress) throws JsonParseException, JsonMappingException, CipherException, IOException {
        return Keys.exportPrivateKeyFromAddress(oneAddress, Config.passphrase);
    }

    public static String exportPrivateKeyFromAccountName(String accountName, String passphrase) throws CipherException, JsonParseException, JsonMappingException, IOException {
        WalletFile walletFile = Store.extractWalletFileFromAccountName(accountName);
        Credentials credentials = Credentials.create((ECKeyPair)Wallet.decrypt((String)passphrase, (WalletFile)walletFile));
        return credentials.getEcKeyPair().getPrivateKey().toString(16);
    }

    public static String exportPrivateKeyFromAccountName(String accountName) throws JsonParseException, JsonMappingException, CipherException, IOException {
        return Keys.exportPrivateKeyFromAccountName(accountName, Config.passphrase);
    }

    public static String exportKeyStoreFromAddress(String oneAddress, String passphrase) throws JsonParseException, JsonMappingException, IOException, CipherException {
        WalletFile walletFile = Store.extractWalletFileFromAddress(oneAddress);
        Credentials.create((ECKeyPair)Wallet.decrypt((String)passphrase, (WalletFile)walletFile));
        String content = Store.extractKeyStoreFileFromAddress(oneAddress);
        log.info(content);
        return content;
    }

    public static String exportKeyStoreFromAddress(String oneAddress) throws JsonParseException, JsonMappingException, IOException, CipherException {
        return Keys.exportKeyStoreFromAddress(oneAddress, Config.passphrase);
    }

    public static String exportKeyStoreFromAccountName(String accountName, String passphrase) throws JsonParseException, JsonMappingException, IOException, CipherException {
        WalletFile walletFile = Store.extractWalletFileFromAccountName(accountName);
        Credentials.create((ECKeyPair)Wallet.decrypt((String)passphrase, (WalletFile)walletFile));
        String content = Store.extractKeyStoreFileFromAccountName(accountName);
        return content;
    }

    public static String exportKeyStoreFromAccountName(String accountName) throws JsonParseException, JsonMappingException, IOException, CipherException {
        return Keys.exportKeyStoreFromAccountName(accountName, Config.passphrase);
    }

    public static Map<String, String> listAccounts() {
        return Store.getLocalAccounts();
    }

    public static String getKeysLocation() {
        return Store.getDefaultKeyDirectory();
    }

    public static boolean setAccountName(String oneAddress, String accountName) {
        Store.setAccountName(oneAddress, accountName);
        return true;
    }

    public static void cleanKeyStore() throws IOException {
        Store.clean();
    }
}

