/*
 * Decompiled with CFR 0.152.
 */
package one.harmony.cmd;

import java.util.List;
import one.harmony.account.Account;
import one.harmony.account.Address;
import one.harmony.keys.Store;
import one.harmony.rpc.ShardingStructure;
import one.harmony.sharding.Sharding;
import one.harmony.transaction.Handler;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Wallet;
import org.web3j.crypto.WalletFile;

public class Transfer {
    private long nonce = -1L;
    private final String from;
    private final String to;
    private final String amount;
    private long gas = 21000L;
    private final long gasPrice;
    private final int fromShard;
    private final int toShard;
    private final String data;
    private Handler handler;

    public Transfer(String from, String to) {
        this.from = from;
        this.to = to;
        this.amount = "0";
        this.gasPrice = 1L;
        this.fromShard = 0;
        this.toShard = 0;
        this.data = "";
    }

    public Transfer(String from, String to, String amount) {
        this.from = from;
        this.to = to;
        this.amount = amount;
        this.gasPrice = 1L;
        this.fromShard = 0;
        this.toShard = 0;
        this.data = "";
    }

    public Transfer(String from, String to, String amount, long gasPrice) {
        this.from = from;
        this.to = to;
        this.amount = amount;
        this.gasPrice = gasPrice;
        this.fromShard = 0;
        this.toShard = 0;
        this.data = "";
    }

    public Transfer(String from, String to, String amount, int fromShard, int toShard) {
        this.from = from;
        this.to = to;
        this.amount = amount;
        this.gasPrice = 1L;
        this.fromShard = fromShard;
        this.toShard = toShard;
        this.data = "";
    }

    public Transfer(String from, String to, String amount, int fromShard, int toShard, String data) {
        this.from = from;
        this.to = to;
        this.amount = amount;
        this.gasPrice = 1L;
        this.fromShard = fromShard;
        this.toShard = toShard;
        this.data = data;
    }

    public Transfer(String from, String to, String amount, long gasPrice, int fromShard, int toShard) {
        this.from = from;
        this.to = to;
        this.amount = amount;
        this.gasPrice = gasPrice;
        this.fromShard = fromShard;
        this.toShard = toShard;
        this.data = "";
    }

    public Transfer(String from, String to, String amount, long gasPrice, int fromShard, int toShard, String data) {
        this.from = from;
        this.to = to;
        this.amount = amount;
        this.gasPrice = gasPrice;
        this.fromShard = fromShard;
        this.toShard = toShard;
        this.data = data;
    }

    public void SetNonce(long nonce) {
        this.nonce = nonce;
    }

    public void SetGas(long gas) {
        this.gas = gas;
    }

    public void prepare(String passphrase) throws Exception {
        this.prepareInternal(passphrase, null);
    }

    public void prepare(String passphrase, String nodeUrl) throws Exception {
        this.prepareInternal(passphrase, nodeUrl);
    }

    public String execute(int chainID, boolean dryRun, int waitToConfirmTime) throws Exception {
        return this.handler.execute(chainID, this.nonce, this.to, this.data, this.amount, this.gas, this.gasPrice, this.fromShard, this.toShard, dryRun, waitToConfirmTime);
    }

    private void prepareInternal(String passphrase, String nodeUrl) throws Exception {
        List<ShardingStructure.RPCRoutes> shards = Sharding.getShardingStructure();
        if (!Sharding.validateShardIDs(this.fromShard, this.toShard, shards.size())) {
            throw new IllegalArgumentException("Invalid shard ids passed");
        }
        String url = nodeUrl != null ? nodeUrl : Sharding.getHandlerFor(shards, this.fromShard);
        String accountName = Store.getAccountNameFromAddress(this.from);
        boolean isHex = false;
        Address address = new Address(this.from, isHex);
        WalletFile walletFile = Store.extractWalletFileFromAddress(this.from);
        Credentials credentials = Credentials.create((ECKeyPair)Wallet.decrypt((String)passphrase, (WalletFile)walletFile));
        Account account = new Account(accountName, address, credentials, walletFile);
        this.handler = new Handler(account, url);
    }
}

