/*
 * Decompiled with CFR 0.152.
 */
package one.harmony.common;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedBytes;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import org.bitcoinj.core.NetworkParameters;

public abstract class PrefixedChecksummedBytes
implements Serializable,
Cloneable,
Comparable<PrefixedChecksummedBytes> {
    protected final transient NetworkParameters params;
    protected final byte[] bytes;

    protected PrefixedChecksummedBytes(NetworkParameters params, byte[] bytes) {
        this.params = (NetworkParameters)Preconditions.checkNotNull((Object)params);
        this.bytes = (byte[])Preconditions.checkNotNull((Object)bytes);
    }

    public final NetworkParameters getParameters() {
        return this.params;
    }

    public int hashCode() {
        return Objects.hash(this.params, Arrays.hashCode(this.bytes));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrefixedChecksummedBytes other = (PrefixedChecksummedBytes)o;
        return this.params.equals((Object)other.params) && Arrays.equals(this.bytes, other.bytes);
    }

    public PrefixedChecksummedBytes clone() throws CloneNotSupportedException {
        return (PrefixedChecksummedBytes)super.clone();
    }

    @Override
    public int compareTo(PrefixedChecksummedBytes o) {
        int result = this.params.getId().compareTo(o.params.getId());
        return result != 0 ? result : UnsignedBytes.lexicographicalComparator().compare(this.bytes, o.bytes);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(this.params.getId());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            Field paramsField = PrefixedChecksummedBytes.class.getDeclaredField("params");
            paramsField.setAccessible(true);
            paramsField.set(this, Preconditions.checkNotNull((Object)NetworkParameters.fromID((String)in.readUTF())));
            paramsField.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchFieldException x) {
            throw new RuntimeException(x);
        }
    }
}

