/*
 * Decompiled with CFR 0.152.
 */
package one.harmony.keys;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import one.harmony.account.Address;
import one.harmony.common.Config;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.crypto.Bip32ECKeyPair;
import org.web3j.crypto.CipherException;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.MnemonicUtils;
import org.web3j.crypto.Wallet;
import org.web3j.crypto.WalletFile;

public class Store {
    private static final Logger log = LoggerFactory.getLogger(Store.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private static void init() {
        File keysDir = new File(Store.getDefaultKeyDirectory());
        if (!keysDir.exists()) {
            keysDir.mkdirs();
            keysDir.setExecutable(true);
            keysDir.setReadable(true);
            keysDir.setWritable(true);
        }
    }

    public static File getKeyFileFromAccountName(String accountName) throws FileNotFoundException {
        String keysDirName = Store.getDefaultKeyDirectory();
        File keysDir = new File(keysDirName);
        for (File file : keysDir.listFiles()) {
            if (!file.isDirectory() || !file.getName().equals(accountName)) continue;
            return file.listFiles()[0];
        }
        throw new FileNotFoundException();
    }

    public static File getKeyFileFromAddress(String oneAddress) throws FileNotFoundException {
        String keysDirName = Store.getDefaultKeyDirectory();
        File keysDir = new File(keysDirName);
        for (File file : keysDir.listFiles()) {
            File keyFile;
            if (!file.isDirectory() || !(keyFile = file.listFiles()[0]).getName().equals(oneAddress + ".json")) continue;
            return keyFile;
        }
        throw new FileNotFoundException();
    }

    public static String getAccountNameFromAddress(String oneAddress) throws IllegalArgumentException {
        String keysDirName = Store.getDefaultKeyDirectory();
        File keysDir = new File(keysDirName);
        for (File file : keysDir.listFiles()) {
            File keyFile;
            if (!file.isDirectory() || !(keyFile = file.listFiles()[0]).getName().equals(oneAddress + ".json")) continue;
            return file.getName();
        }
        throw new IllegalArgumentException("Account does not exists for address: " + oneAddress);
    }

    public static Map<String, String> getLocalAccounts() {
        HashMap<String, String> accounts = new HashMap<String, String>();
        String keysDirName = Store.getDefaultKeyDirectory();
        File keysDir = new File(keysDirName);
        if (keysDir != null && keysDir.listFiles() != null) {
            for (File file : keysDir.listFiles()) {
                if (!file.isDirectory()) continue;
                accounts.put(file.getName(), file.listFiles()[0].getName());
            }
        }
        return accounts;
    }

    public static boolean doesNamedAccountExists(String name) {
        return Store.getLocalAccounts().containsKey(name);
    }

    public static boolean doesAccountExists(String oneAddress) {
        return Store.getLocalAccounts().values().contains(oneAddress);
    }

    public static String searchForAccount(String oneAddress) throws IllegalArgumentException {
        return Store.getAccountNameFromAddress(oneAddress);
    }

    public static String getDefaultKeyDirectory() {
        return Store.getDefaultKeyDirectory(System.getProperty("os.name"));
    }

    public static File createAccountKeyDir(String accountName) {
        String accountDirName = String.format("%s%s%s", Store.getDefaultKeyDirectory(), File.separator, accountName);
        File accountDir = new File(accountDirName);
        accountDir.mkdir();
        return accountDir;
    }

    public static boolean setAccountName(String oneAddress, String accountName) {
        File keysDir = new File(Store.getDefaultKeyDirectory());
        for (File dir : keysDir.listFiles()) {
            File addressFile;
            if (!dir.isDirectory() || !(addressFile = dir.listFiles()[0]).getName().equals(oneAddress)) continue;
            File newDir = new File(String.format("%s%s%s", dir.getParent(), File.separator, accountName));
            dir.renameTo(newDir);
        }
        return true;
    }

    private static String getDefaultKeyDirectory(String osName1) {
        String osName = osName1.toLowerCase();
        if (osName.startsWith("win")) {
            return String.format("%s%s%s%s%s", System.getenv("APPDATA"), File.separator, Config.keystore, File.separator, Config.accounts);
        }
        return String.format("%s%s%s%s%s", System.getProperty("user.home"), File.separator, Config.keystore, File.separator, Config.accounts);
    }

    public static Credentials loadBip44Credentials(String password, String mnemonic) {
        byte[] seed = MnemonicUtils.generateSeed((String)mnemonic, (String)password);
        Bip32ECKeyPair masterKeypair = Bip32ECKeyPair.generateKeyPair((byte[])seed);
        int[] path = new int[]{-2147483604, -2147482625, Integer.MIN_VALUE, 0};
        Bip32ECKeyPair bip44Keypair = Bip32ECKeyPair.deriveKeyPair((Bip32ECKeyPair)masterKeypair, (int[])path);
        return Credentials.create((ECKeyPair)bip44Keypair);
    }

    public static void generateWalletFile(String accountName, String password, ECKeyPair ecKeyPair) throws CipherException, IOException {
        WalletFile walletFile = Wallet.createStandard((String)password, (ECKeyPair)ecKeyPair);
        File destinationDirectory = Store.createAccountKeyDir(accountName);
        String fileName = Store.getWalletFileName(Address.toBech32(walletFile.getAddress()));
        File destination = new File(destinationDirectory, fileName);
        objectMapper.writeValue(destination, (Object)walletFile);
    }

    public static WalletFile extractWalletFileFromAccountName(String accountName) throws JsonParseException, JsonMappingException, IOException {
        File keyFile = Store.getKeyFileFromAccountName(accountName);
        return (WalletFile)objectMapper.readValue(keyFile, WalletFile.class);
    }

    public static WalletFile extractWalletFileFromAddress(String oneAddress) throws JsonParseException, JsonMappingException, IOException {
        File keyFile = Store.getKeyFileFromAddress(oneAddress);
        return (WalletFile)objectMapper.readValue(keyFile, WalletFile.class);
    }

    private static String usingBufferedReader(File file) {
        StringBuilder contentBuilder = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String sCurrentLine;
            while ((sCurrentLine = br.readLine()) != null) {
                contentBuilder.append(sCurrentLine).append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contentBuilder.toString();
    }

    public static String extractKeyStoreFileFromAccountName(String accountName) throws FileNotFoundException {
        File keyFile = Store.getKeyFileFromAccountName(accountName);
        return Store.usingBufferedReader(keyFile);
    }

    public static String extractKeyStoreFileFromAddress(String oneAddress) throws FileNotFoundException {
        File keyFile = Store.getKeyFileFromAddress(oneAddress);
        return Store.usingBufferedReader(keyFile);
    }

    private static String getWalletFileName(String accountName) {
        return accountName + ".json";
    }

    public static void clean() throws IOException {
        File keysDir = new File(Store.getDefaultKeyDirectory());
        if (keysDir != null && keysDir.listFiles() != null) {
            for (File file : keysDir.listFiles()) {
                if (!file.isDirectory()) continue;
                FileUtils.deleteDirectory((File)file);
            }
        }
    }

    public static void clean(String accountName) throws IOException {
        File keysDir = new File(Store.getDefaultKeyDirectory());
        if (keysDir != null && keysDir.listFiles() != null) {
            for (File file : keysDir.listFiles()) {
                if (!file.isDirectory() || !file.getName().equals(accountName)) continue;
                FileUtils.deleteDirectory((File)file);
                return;
            }
        }
    }

    static {
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Store.init();
    }
}

