/*
 * Decompiled with CFR 0.152.
 */
package one.harmony.account;

import java.io.ByteArrayOutputStream;
import org.bitcoinj.core.AddressFormatException;
import org.bitcoinj.core.Bech32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.utils.Numeric;

public class Address {
    private static final Logger log = LoggerFactory.getLogger(Address.class);
    private static final int HASH_LENGTH = 32;
    private static final int ADDRESS_LENGTH = 20;
    private static final String BECH32_ADDRESS_HRP = "one";
    private final String oneAddr;
    private final String hexAddr;

    public Address(String addr, boolean isHex) {
        if (isHex) {
            this.oneAddr = Address.toBech32(addr);
            this.hexAddr = addr;
        } else {
            this.oneAddr = addr;
            this.hexAddr = Address.parseBech32(addr);
        }
    }

    public String getOneAddr() {
        return this.oneAddr;
    }

    public String getHexAddr() {
        return this.hexAddr;
    }

    public static boolean isOneAddr(String addr) {
        return addr.startsWith(BECH32_ADDRESS_HRP);
    }

    private static byte[] convertBits(byte[] in, int inStart, int inLen, int fromBits, int toBits, boolean pad) throws AddressFormatException {
        int acc = 0;
        int bits = 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream(64);
        int maxv = (1 << toBits) - 1;
        int max_acc = (1 << fromBits + toBits - 1) - 1;
        for (int i = 0; i < inLen; ++i) {
            int value = in[i + inStart] & 0xFF;
            if (value >>> fromBits != 0) {
                throw new AddressFormatException(String.format("Input value '%X' exceeds '%d' bit size", value, fromBits));
            }
            acc = (acc << fromBits | value) & max_acc;
            bits += fromBits;
            while (bits >= toBits) {
                out.write(acc >>> (bits -= toBits) & maxv);
            }
        }
        if (pad) {
            if (bits > 0) {
                out.write(acc << toBits - bits & maxv);
            }
        } else if (bits >= fromBits || (acc << toBits - bits & maxv) != 0) {
            throw new AddressFormatException("Could not convert bits, invalid padding");
        }
        return out.toByteArray();
    }

    private static String convertAndEncode(String hrp, byte[] data) {
        byte[] converted = Address.convertBits(data, 0, data.length, 8, 5, true);
        return Bech32.encode((String)hrp, (byte[])converted);
    }

    private static byte[] decodeAndConvert(String bech) {
        Bech32.Bech32Data bech32Data = Bech32.decode((String)bech);
        return Address.convertBits(bech32Data.data, 0, bech32Data.data.length, 5, 8, true);
    }

    public static String parseBech32(String oneAddress) {
        return Numeric.toHexString((byte[])Address.decodeAndConvert(oneAddress));
    }

    public static String toBech32(String hexAddress) {
        return Address.convertAndEncode(BECH32_ADDRESS_HRP, Numeric.hexStringToByteArray((String)hexAddress));
    }
}

