/*
 * Decompiled with CFR 0.152.
 */
package one.harmony.cmd;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import one.harmony.common.Config;
import one.harmony.rpc.HmyResponse;
import one.harmony.rpc.RPC;
import one.harmony.rpc.ShardingStructure;
import one.harmony.sharding.Sharding;
import org.web3j.utils.Numeric;

public class Balance {
    public static String check(String oneAddress) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        List<ShardingStructure.RPCRoutes> structure = Sharding.getShardingStructure();
        for (ShardingStructure.RPCRoutes rpcRoutes : structure) {
            RPC node = new RPC(rpcRoutes.getHttp());
            HmyResponse response = (HmyResponse)node.getBalance(oneAddress).send();
            if (response.hasError()) {
                throw new Exception("failed to fetch the balance for address: " + oneAddress);
            }
            BigInteger bln = Numeric.toBigInt((String)((String)response.getResult()));
            sb.append(String.format("{ \"shard\": %d, \"amount\": %s }", rpcRoutes.getShardID(), Balance.covertBalanceToReadableFormat(bln)));
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(']');
        return sb.toString();
    }

    public static String checkLocal(String oneAddress) throws Exception {
        RPC node = new RPC(Config.node);
        HmyResponse response = (HmyResponse)node.getBalance(oneAddress).send();
        if (response.hasError()) {
            throw new Exception("failed to fetch the balance for address: " + oneAddress);
        }
        BigInteger bln = Numeric.toBigInt((String)((String)response.getResult()));
        return Balance.covertBalanceToReadableFormat(bln);
    }

    private static String covertBalanceToReadableFormat(BigInteger balance) {
        BigDecimal decimalBln = new BigDecimal(balance);
        BigDecimal nano = new BigDecimal(BigInteger.TEN.pow(9));
        double bln = decimalBln.divide(nano).divide(nano).doubleValue();
        return String.valueOf(bln);
    }

    public static void main(String[] args) throws Exception {
        String oneAddress = "one1pdv9lrdwl0rg5vglh4xtyrv3wjk3wsqket7zxy";
        System.out.println(Balance.checkLocal(oneAddress));
    }
}

