/*
 * Decompiled with CFR 0.152.
 */
package one.harmony.rpc;

import java.util.Arrays;
import java.util.Collections;
import one.harmony.common.Config;
import one.harmony.rpc.HmyResponse;
import one.harmony.rpc.ShardingStructure;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.Request;
import org.web3j.protocol.http.HttpService;

public class RPC {
    private final HttpService service;

    public RPC() {
        this.service = new HttpService(Config.node);
    }

    public RPC(HttpService service) {
        this.service = service;
    }

    public RPC(String url) {
        this.service = new HttpService(url);
    }

    public RPC(String url, boolean includeRawResponse) {
        this.service = new HttpService(url, includeRawResponse);
    }

    public Request<?, HmyResponse> rpcClient() {
        return new Request("", Collections.emptyList(), (Web3jService)this.service, HmyResponse.class);
    }

    public Request<?, HmyResponse> sendRawTransaction(String raw) {
        return new Request("hmy_sendRawTransaction", Arrays.asList(raw), (Web3jService)this.service, HmyResponse.class);
    }

    public Request<?, ShardingStructure> getShardingStructure() {
        return new Request("hmy_getShardingStructure", Collections.emptyList(), (Web3jService)this.service, ShardingStructure.class);
    }

    public Request<?, HmyResponse> getBalance(String oneAddress) {
        return new Request("hmy_getBalance", Arrays.asList(oneAddress, "latest"), (Web3jService)this.service, HmyResponse.class);
    }

    public Request<?, HmyResponse> getProtocolVersion() {
        return new Request("hmy_protocolVersion", Arrays.asList("latest"), (Web3jService)this.service, HmyResponse.class);
    }

    public Request<?, HmyResponse> getTransactionCount(String hexAddr) {
        return new Request("hmy_getTransactionCount", Arrays.asList(hexAddr, "latest"), (Web3jService)this.service, HmyResponse.class);
    }

    public Request<?, HmyResponse> getTransactionReceipt(String txHash) {
        return new Request("hmy_getTransactionReceipt", Arrays.asList(txHash), (Web3jService)this.service, HmyResponse.class);
    }
}

