/*
 * Decompiled with CFR 0.152.
 */
package one.harmony.transaction;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import one.harmony.rpc.HmyResponse;
import one.harmony.rpc.RPC;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECDSASignature;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Sign;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Bytes;
import org.web3j.utils.Numeric;

public class Transaction {
    private BigInteger nonce;
    private BigInteger gasPrice;
    private BigInteger gasLimit;
    private int shardID;
    private int toShardID;
    private String recipient;
    private BigInteger amount;
    private byte[] payload;
    private Sign.SignatureData signature;
    protected byte[] rlpEncoded;
    private byte[] rawHash;
    private String txHash;

    public Transaction(long nonce, String recipient, int shardID, int toShardID, BigInteger amount, long gasLimit, BigInteger gasPrice, byte[] payload) {
        this.nonce = BigInteger.valueOf(nonce);
        this.recipient = recipient;
        this.shardID = shardID;
        this.toShardID = toShardID;
        this.amount = amount;
        this.gasLimit = BigInteger.valueOf(gasLimit);
        this.gasPrice = gasPrice;
        this.payload = payload;
    }

    public BigInteger getNonce() {
        return this.nonce;
    }

    public void setNonce(BigInteger nonce) {
        this.nonce = nonce;
    }

    public BigInteger getGasPrice() {
        return this.gasPrice;
    }

    public void setGasPrice(BigInteger gasPrice) {
        this.gasPrice = gasPrice;
    }

    public BigInteger getGasLimit() {
        return this.gasLimit;
    }

    public void setGasLimit(BigInteger gasLimit) {
        this.gasLimit = gasLimit;
    }

    public int getShardID() {
        return this.shardID;
    }

    public void setShardID(int shardID) {
        this.shardID = shardID;
    }

    public int getToShardID() {
        return this.toShardID;
    }

    public void setToShardID(int toShardID) {
        this.toShardID = toShardID;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public Sign.SignatureData getSignature() {
        return this.signature;
    }

    public void setSignature(Sign.SignatureData signature) {
        this.signature = signature;
    }

    public byte[] getRlpEncoded() {
        return this.rlpEncoded;
    }

    public void setRlpEncoded(byte[] rlpEncoded) {
        this.rlpEncoded = rlpEncoded;
    }

    public byte[] getRawHash() {
        return this.rawHash;
    }

    public void setRawHash(byte[] rawHash) {
        this.rawHash = rawHash;
    }

    public String getTxHash() {
        return this.txHash;
    }

    public void setTxHash(String txHash) {
        this.txHash = txHash;
    }

    public Transaction sign(int chainId, Credentials credentials) {
        Sign.SignatureData signatureData;
        byte[] encoded = this.encode(chainId);
        this.signature = signatureData = Transaction.signMessage(chainId, encoded, credentials.getEcKeyPair(), true);
        encoded = this.encode(signatureData);
        this.rlpEncoded = encoded;
        this.rawHash = Numeric.toHexString((byte[])encoded).getBytes();
        return this;
    }

    private static byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }

    private byte[] encode(long chainId) {
        Sign.SignatureData signatureData = new Sign.SignatureData((byte)chainId, new byte[0], new byte[0]);
        return this.encode(signatureData);
    }

    private byte[] encode(Sign.SignatureData signatureData) {
        List<RlpType> values = this.asRlpValues(signatureData);
        RlpList rlpList = new RlpList(values);
        return RlpEncoder.encode((RlpType)rlpList);
    }

    private List<RlpType> asRlpValues(Sign.SignatureData signatureData) {
        ArrayList<RlpType> result = new ArrayList<RlpType>();
        result.add((RlpType)RlpString.create((BigInteger)this.getNonce()));
        result.add((RlpType)RlpString.create((BigInteger)this.getGasPrice()));
        result.add((RlpType)RlpString.create((BigInteger)this.getGasLimit()));
        result.add((RlpType)RlpString.create((long)this.getShardID()));
        result.add((RlpType)RlpString.create((long)this.getToShardID()));
        result.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getRecipient())));
        result.add((RlpType)RlpString.create((BigInteger)this.getAmount()));
        result.add((RlpType)RlpString.create((byte[])this.getPayload()));
        if (signatureData != null) {
            result.add((RlpType)RlpString.create((byte)signatureData.getV()));
            result.add((RlpType)RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])signatureData.getR())));
            result.add((RlpType)RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])signatureData.getS())));
        }
        return result;
    }

    public String sendRawTransaction() throws IOException {
        return ((HmyResponse)new RPC().sendRawTransaction(this.rawHash.toString()).send()).getJsonrpc();
    }

    private static Sign.SignatureData signMessage(int chainId, byte[] message, ECKeyPair keyPair, boolean needToHash) {
        BigInteger publicKey = keyPair.getPublicKey();
        byte[] messageHash = needToHash ? Hash.sha3((byte[])message) : message;
        ECDSASignature sig = keyPair.sign(messageHash);
        int recId = -1;
        for (int i = 0; i < 4; ++i) {
            BigInteger k = Sign.recoverFromSignature((int)i, (ECDSASignature)sig, (byte[])messageHash);
            if (k == null || !k.equals(publicKey)) continue;
            recId = i;
            break;
        }
        if (recId == -1) {
            throw new RuntimeException("Could not construct a recoverable key. Are your credentials valid?");
        }
        int headerByte = recId + 27;
        if (chainId != 0) {
            headerByte = 0;
            headerByte += 35;
            headerByte += chainId * 2;
            headerByte += recId;
        }
        byte v = (byte)headerByte;
        byte[] r = Numeric.toBytesPadded((BigInteger)sig.r, (int)32);
        byte[] s = Numeric.toBytesPadded((BigInteger)sig.s, (int)32);
        return new Sign.SignatureData(v, r, s);
    }
}

