package com.jpro.webapi;

import com.jpro.webapi.annotation.Experimental;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyLongProperty;

/**
 * Holds information about the current running instance.
 */
@Experimental
public interface InstanceInfo {

    /**
     * Returns a property with the average latency in milliseconds.
     *
     * @return an integer property representing the current latency.
     */
    ReadOnlyIntegerProperty latencyProperty();
    /**
     * Returns the average latency in milliseconds.
     *
     * @return an integer value representing the current latency.
     */
    int getLatency();

    /**
     * Returns the initial host name of this instance.
     *
     * @return a string value representing the initial host name.
     */
    String getInitialHostName();

    /**
     * Returns the creation time of this instance in milliseconds.
     *
     * @return a long value representing the creation time.
     */
    long creationTime();

    /**
     * Returns a property with the data sent via the WebSocket connection.
     *
     * @return a number of data sent in bytes.
     */
    ReadOnlyLongProperty dataSentWSProperty();

    /**
     * Returns the length of the data sent via the WebSocket connection.
     *
     * @return a number of data sent in bytes.
     */
    long getDataSentWS();

    /**
     * Returns a property with the data received via the WebSocket connection.
     *
     * @return a number of data received in bytes.
     */
    ReadOnlyLongProperty dataReceivedWSProperty();

    /**
     * Returns the length of the data received via the WebSocket connection.
     *
     * @return a number of data received in bytes.
     */
    long getDataReceivedWS();

    /**
     * Returns a property which indicates whether the user is considered as inactive.
     */
    ReadOnlyBooleanProperty afkProperty();

    /**
     * Returns a boolean value which indicates whether the user is considered as inactive.
     */
    boolean isAfk();

    /**
     * Returns a property which indicates whether the application is running in the background.
     */
    ReadOnlyBooleanProperty  backgroundProperty();

    /**
     * Returns a boolean value which indicates whether the application is running in the background.
     */
    boolean isBackground();

    /**
     * Returns a property with the time of the last user action in milliseconds.
     */
    ReadOnlyLongProperty lastActionTimeProperty();

    /**
     * Returns a value with the time of the last user action in milliseconds.
     */
    long getLastActionTime();

    /**
     * Returns a property with the number of nodes created.
     */
    ReadOnlyIntegerProperty nodesCreatedProperty();

    /**
     * Returns the number of nodes created.
     */
    int getNodesCreated();

    /**
     * Returns a property with the number of nodes synchronized.
     */
    ReadOnlyIntegerProperty nodesSynchronizedProperty();

    /**
     * Returns the number of nodes synchronized.
     */
    int getNodesSynchronized();

    /**
     * Returns a property with the number of nodes collected.
     */
    ReadOnlyIntegerProperty nodesCollectedProperty();

    /**
     * Returns the number of nodes collected.
     */
    int getNodesCollected();
}
