package com.jpro.webapi.annotation;

import java.lang.annotation.*;

/**
 * Indicates that a public API of the annotated element (class, method or field) is not in stable state yet.
 * It may be renamed, changed or even removed in a future version. This annotation refers to API status only,
 * it doesn't mean that the implementation has an 'experimental' quality.
 */
@Documented
@Retention(RetentionPolicy.CLASS)
@Target({ElementType.TYPE, ElementType.METHOD})
public @interface Experimental {

    /**
     * Provides a description or additional information about the experimental element.
     *
     * @return a string value.
     */
    String value() default "";
}
