/*
 * Decompiled with CFR 0.152.
 */
package com.jpro.webapi;

import com.jpro.webapi.PromiseJSVariable;
import com.jpro.webapi.WebAPI;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class JSVariable {
    WebAPI webAPI;
    String name;
    CompletableFuture<Void> future;
    private static final HashSet<WeakReferenceWithRunnable> references = new HashSet();
    private static final ReferenceQueue<?> queue = new ReferenceQueue();

    public JSVariable(WebAPI webAPI, String name) {
        this(webAPI, name, name + " = undefined;");
    }

    public JSVariable(WebAPI webAPI, String name, String cleanup) {
        this(webAPI, name, cleanup, CompletableFuture.completedFuture(null));
    }

    public JSVariable(WebAPI webAPI, String name, String cleanup, CompletableFuture<Void> future) {
        this.webAPI = webAPI;
        this.name = name;
        this.future = future;
        JSVariable.onCleanup(this, new CleanupFunction(name, cleanup, webAPI));
    }

    public CompletableFuture<String> getString() {
        return this.webAPI.executeScriptWithFuture(this.getName() + ";");
    }

    public CompletableFuture<Void> onComplete() {
        return this.future;
    }

    public void onError(Consumer<Throwable> onError) {
        this.future.exceptionally(e -> {
            onError.accept((Throwable)e);
            return null;
        });
    }

    public WebAPI getWebAPI() {
        return this.webAPI;
    }

    public String getName() {
        return this.name;
    }

    private static void onCleanup(Object obj, Runnable r) {
        JSVariable.onCleanup(new WeakReferenceWithRunnable(obj, r));
    }

    private static void onCleanup(WeakReferenceWithRunnable weakref) {
        references.add(weakref);
    }

    public static JSVariable futureToPromise(WebAPI webAPI, CompletableFuture<JSVariable> future) {
        JSVariable var1 = webAPI.executeScriptWithVariable("(function() {var myresolve; var myPromise = new Promise(function(resolve, reject) {     myresolve = resolve;}); return {resolve: myresolve, promise: myPromise};})();");
        future.thenAccept(var2 -> var2.webAPI.executeScript(var1.getName() + ".resolve(" + var2.getName() + ");"));
        return webAPI.executeScriptWithVariable(var1.getName() + ".promise;");
    }

    public CompletableFuture<Boolean> isPromise() {
        return this.webAPI.executeScriptWithFuture(this.name + " instanceof Promise;").thenApply(v -> {
            if (v.equals("true")) {
                return true;
            }
            if (v.equals("false")) {
                return false;
            }
            throw new RuntimeException("Unexpected result: " + v);
        });
    }

    public static CompletableFuture<JSVariable> promiseToFuture(WebAPI webAPI, JSVariable myvar) {
        return webAPI.js().evalFuture("return await " + myvar.getName() + ";");
    }

    public PromiseJSVariable toPromise() {
        return new PromiseJSVariable(this);
    }

    static {
        Thread cleanupDetectorThread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        WeakReferenceWithRunnable r = (WeakReferenceWithRunnable)queue.remove();
                        references.remove(r);
                        r.r.run();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }, "JPro-JSVariable-cleanup-detector");
        cleanupDetectorThread.setDaemon(true);
        cleanupDetectorThread.start();
    }

    private static class CleanupFunction
    implements Runnable {
        String name;
        String code;
        WeakReference<WebAPI> webAPI;

        private CleanupFunction(String name, String code, WebAPI webAPI) {
            this.name = name;
            this.code = code;
            this.webAPI = new WeakReference<WebAPI>(webAPI);
        }

        @Override
        public void run() {
            WebAPI realWebAPI = (WebAPI)this.webAPI.get();
            if (realWebAPI != null) {
                realWebAPI.executeScript(this.code);
            }
        }
    }

    private static class WeakReferenceWithRunnable
    extends WeakReference {
        Runnable r = null;

        WeakReferenceWithRunnable(Object ref, Runnable r) {
            super(ref, queue);
            this.r = r;
        }
    }
}

