package com.jpro.webapi;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.layout.Region;

/**
 * HTMLView is a JavaFX node, which contains HTML content to be rendered in the browser by JPro.
 * The width and height of the displayed HTML content is the width and height of the HTMLView's
 * width and height properties. HTMLView's content is a string with HTML formatted text.
 * <p>
 * Take a look at our samples for more detailed information, on how to use HTMLView:
 * <a href="https://github.com/JPro-one/JPro-Samples">https://github.com/JPro-one/JPro-Samples</a>
 *
 * @author Florian Kirmaier
 */
public class HTMLView extends Region {

    /**
     * Creates an empty instance of the HTMLView, an instance with no content.
     */
    public HTMLView() {
    }

    /**
     * Creates a new instance of HTMLView, with the content provided.
     *
     * @param content the new content, in HTML format
     */
    public HTMLView(String content) {
        this();
        setContent(content);
    }

    private final SimpleStringProperty content = new SimpleStringProperty("");

    private final SimpleBooleanProperty blockMouseInput = new SimpleBooleanProperty(false);

    private final SimpleBooleanProperty blockKeyboardInput = new SimpleBooleanProperty(false);

    /**
     * Defines the content of the HTMLView, as an HTML formatted text.
     *
     * @return content the HTML content as a string property
     */
    public StringProperty contentProperty() {
        return content;
    }

    /**
     * Sets the value of the property content (a string in HTML format).
     *
     * @param content sets the value of the property content
     */
    public void setContent(String content) {
        this.content.set(content);
    }

    /**
     * Gets the value of the property content (a string in HTML format).
     *
     * @return the HTML content as a string.
     */
    public String getContent() {
        return content.get();
    }

    /**
     * Whether the JPro application will get mouse events. The value of
     * this property is <code>true</code> if the JPro application won't
     * get mouse events, when the HTMLView is the target in the JS event.
     * The default value is <code>false</code>.
     */
    public BooleanProperty blockMouseInputProperty() {
        return blockMouseInput;
    }

    /**
     * Sets the value of the property blockMouseInput.
     *
     * @param blockMouseInput the value of the property blockMouseInput
     */
    public void setBlockMouseInput(boolean blockMouseInput) {
        this.blockMouseInput.set(blockMouseInput);
    }

    /**
     * Gets the value of the property blockMouseInput.
     *
     * @return <code>true</code> if the JPro application won't get mouse events,
     * when the HTMLView is the target in the JS event, otherwise <code>false</code>
     */
    public boolean isBlockMouseInput() {
        return blockMouseInput.get();
    }

    /**
     * Whether the JPro application will get keyboard events. The value of
     * this property is <code>true</code> if the JPro application won't
     * get keyboard events, when the HTMLView is the target in the JS event.
     * The default value is <code>false</code>.
     */
    public BooleanProperty blockKeyboardInputProperty() {
        return blockKeyboardInput;
    }

    /**
     * Sets the value of the blockKeyboardInput property.
     *
     * @param blockKeyboardInput the value of the property blockKeyboardInput
     */
    public void setBlockKeyboardInput(boolean blockKeyboardInput) {
        this.blockKeyboardInput.set(blockKeyboardInput);
    }

    /**
     * Gets the value of the property blockKeyboardInput.
     *
     * @return <code>true</code> if the JPro application won't get keyboard events,
     * when the HTMLView is the target in the JS event, otherwise <code>false</code>
     */
    public boolean isBlockKeyboardInput() {
        return blockKeyboardInput.get();
    }

}
