package com.jpro.webapi;

import javafx.application.Application;

/**
 * This class can be used as the starting point of your application.
 * It only adds the benefit, of making the {@link WebAPI} accessible.
 *
 * @author Florian Kirmaier
 */
public abstract class JProApplication extends Application {

    private WebAPI webAPI = null;

    /**
     * Sets the value of the application's {@link WebAPI} to the specified <code>webAPI</code>
     * This method is used internally by JPro.
     *
     * @param webAPI the {@link WebAPI} instance to be set for this application
     */
    public void setWebAPI(WebAPI webAPI) {
        this.webAPI = webAPI;
    }

    /**
     * Gets the value of the application's {@link WebAPI}.
     *
     * @return the {@link WebAPI} instance associated with this application, or <code>null</code> if not set
     */
    public WebAPI getWebAPI() {
        return webAPI;
    }
}
