package com.jpro.webapi;


import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.layout.Region;

/**
 * SVGView is a JavaFX node, which shows SVG-Content in JPro.
 * The width and height of the displayed SVG-content is the
 * width and height of the SVGView's width and height properties.
 * <p>
 * This class works similarly to HTMLView.
 *
 * @author Florian Kirmaier
 */
public class SVGView extends Region {

    /**
     * Creates a new empty SVGView.
     */
    public SVGView() {
    }

    /**
     * Creates a new SVGView, with the content in SVG format.
     *
     * @param content the content, in SVG format
     */
    public SVGView(String content) {
        this();
        setContent(content);
    }

    private final SimpleStringProperty content = new SimpleStringProperty("");

    /**
     * Defines the SVG content of the SVGView. The content is in SVG format.
     */
    public StringProperty contentProperty() {
        return content;
    }

    /**
     * Sets the value of the property content.
     *
     * @param content the content, in SVG format
     */
    public void setContent(String content) {
        this.content.set(content);
    }

    /**
     * Gets the value of the property content.
     *
     * @return content the content, in SVG format
     */
    public String getContent() {
        return content.get();
    }
}