package com.jpro.webapi;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;

/**
 * StageViews are used to incorporate an arbitrary number of stages anywhere in the scenegraph.
 *
 * @author Florian Kirmaier
 */
public class StageView extends Pane {

    /**
     * Creates a new StageView, containing a stage.
     *
     * @param stage a stage to be linked to this StageView
     */
    public StageView(Stage stage) {
        setStage(stage);

        this.setPrefHeight(Double.MAX_VALUE);
        this.setPrefWidth(Double.MAX_VALUE);
        this.setMaxHeight(Double.MAX_VALUE);
        this.setMaxWidth(Double.MAX_VALUE);

        this.widthProperty().addListener((observable, oldValue, newValue) -> {
            if (getWidth() > 0 && getHeight() > 0) {
                System.out.println("wh: " + getWidth() + " - " + getHeight());
                getStage().setWidth(newValue.doubleValue());
            }
        });
        this.heightProperty().addListener((observable, oldValue, newValue) -> {
            if (getWidth() > 0 && getHeight() > 0) {
                System.out.println("wh: " + getWidth() + " - " + getHeight());
                getStage().setHeight(newValue.doubleValue());
            }
        });
        if (getWidth() > 0 && getHeight() > 0) {
            getStage().setHeight(getHeight());
            getStage().setWidth(getWidth());
            System.out.println("wh: " + getWidth() + " - " + getHeight());
        }
    }

    /**
     * Defines the Stage to be linked to this StageView.
     */
    ObjectProperty<Stage> _stageProperty = new SimpleObjectProperty<>(null);

    public ObjectProperty<Stage> stageProperty() {
        return _stageProperty;
    }

    /**
     * Sets the value of the property stage.
     *
     * @param stage the stage to be linked to this StageView
     */
    public void setStage(Stage stage) {
        stageProperty().set(stage);
    }

    /**
     * Gets the value of the property stage.
     *
     * @return stage the stage linked to this StageView
     */
    public Stage getStage() {
        return stageProperty().get();
    }

    //@Override
    //public void resize(double width, double height) {
    //    if(width > 0 && height > 0) {
    //        getStage().setWidth(width);
    //        getStage().setHeight(height);
    //    }
    //}
}
