package com.jpro.webapi.js;

import com.jpro.webapi.JSVariable;
import com.jpro.webapi.PromiseJSVariable;

import java.util.concurrent.CompletableFuture;

/**
 * This interface defines provides the main API for executing JavaScript code on a client.
 */
public interface JS {

    /**
     * Executes the given JavaScript code synchronously on the client.
     * The method returns a {@link JSVariable} that represents the result of the executed code.
     *
     * @param code the JavaScript code to be executed
     * @return a {@link JSVariable} representing the result of the code execution
     */
    JSVariable eval(String code);

    /**
     * Executes the given code in the javascript client.
     * The code must be asynchronous and end with a return statement.
     *
     * @param code the asynchronous JavaScript code to be executed
     * @return a {@link PromiseJSVariable} representing the result of the asynchronous code execution
     */
    PromiseJSVariable evalAsync(String code);

    /**
     * Executes the given code in the javascript client.
     * The code must be asynchronous and end with a return statement.
     *
     * @param code the JavaScript code to be executed
     * @return a {@link CompletableFuture<JSVariable>} that will be completed with the result of the code execution
     */
    CompletableFuture<JSVariable> evalFuture(String code);
}
