package com.jpro.webapi.server;

import com.jpro.webapi.annotation.Experimental;

import java.util.function.Function;

/**
 * This class provides some basic functionality to interact with the server.
 * This class is experimental and may change in future versions.
 *
 * @author Florian Kirmaier
 */
@Experimental
public abstract class ServerAPI {

    private static ServerAPI serverAPI;

    /**
     * Sets the singleton instance of the server API.
     * This method is used internally by JPro to set the server API.
     *
     * @param serverAPI the server API to set
     */
    public static void setServerAPI(ServerAPI serverAPI) {
        ServerAPI.serverAPI = serverAPI;
    }

    /**
     * Returns the singleton instance of the server API.
     *
     * @return the singleton instance of the server API
     * @throws RuntimeException if the server API is not available
     */
    public static ServerAPI getServerAPI() {
        if (serverAPI == null) {
            throw new RuntimeException("ServerAPI not available. Make sure you are running in a JPro environment.");
        }
        return serverAPI;
    }

    /**
     * Return the version of the currently running JPro server.
     *
     * @return the version string
     * @since 2024.2.2
     */
    public abstract String getJProVersion();

    /**
     * Adds a request handler to the server.
     * If the response from the handler is empty, the next handler will be called.
     * If no handler can handle the request, the JPro Server will handle it.
     *
     * @param handler the function that processes requests and returns responses
     */
    public abstract void addRequestHandler(Function<Request, Response> handler);

    /**
     * Removes a request handler from the server.
     *
     * @param handler the function to be removed from handling requests
     */
    public abstract void removeRequestHandler(Function<Request, Response> handler);
}
