/*
 * Decompiled with CFR 0.152.
 */
package com.jpro.webapi;

import com.jpro.webapi.HTMLView;
import com.jpro.webapi.InstanceCloseListener;
import com.jpro.webapi.InstanceInfo;
import com.jpro.webapi.JSVariable;
import com.jpro.webapi.ScriptResultListener;
import com.jpro.webapi.ServerInfo;
import com.jpro.webapi.WebAPIConsumer;
import com.jpro.webapi.WebCallback;
import com.jpro.webapi.annotation.Experimental;
import com.jpro.webapi.js.JS;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.SelectionMode;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import javafx.stage.Window;

public abstract class WebAPI {
    private static Class<?> webAPIImplClass = null;
    private static BiConsumer<Node, WebAPIConsumer> getWebAPIImpl = null;
    private static WebAPIStatic webAPIStaticImpl = null;

    public static boolean isBrowser() {
        return webAPIImplClass != null;
    }

    public static WebAPI getWebAPI(Window window) throws RuntimeException {
        if (!WebAPI.isBrowser()) {
            throw new RuntimeException("createWebAPI is not implemented on this Platform!");
        }
        try {
            Method method = webAPIImplClass.getMethod("getWebAPI", Window.class);
            return (WebAPI)method.invoke(null, window);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to create the WebAPI!", e);
        }
    }

    public static WebAPI getWebAPI(Scene scene) throws RuntimeException {
        if (scene.getWindow() == null) {
            throw new RuntimeException("getWebAPI: The window of the provided scene is null!");
        }
        return WebAPI.getWebAPI(scene.getWindow());
    }

    public static void getWebAPI(Node node, WebAPIConsumer consumer) {
        getWebAPIImpl.accept(node, consumer);
    }

    public static void setWebAPIImpl(Class<?> clazz, BiConsumer<Node, WebAPIConsumer> _getWebAPIImpl, WebAPIStatic staticImpl) {
        webAPIImplClass = clazz;
        getWebAPIImpl = _getWebAPIImpl;
        webAPIStaticImpl = staticImpl;
    }

    public abstract InstanceInfo getInstanceInfo();

    @Deprecated
    public String getServerName() {
        return this.getBrowserURL();
    }

    public abstract String getBrowserURL();

    public abstract void setCookie(String var1, String var2);

    public abstract void deleteCookie(String var1);

    public abstract ObservableMap<String, String> getCookies();

    public abstract Map<String, String> getWebsocketCookies();

    public abstract boolean isMobile();

    public abstract String getLanguage();

    public abstract List<String> getLanguages();

    public abstract String getPlatformOld();

    public abstract String getPlatform();

    public abstract Locale getLocale();

    public abstract TimeZone getTimeZone();

    public Map<String, String> getURLQueryParams() {
        String url = this.getBrowserURL();
        HashMap<String, String> result = new HashMap<String, String>();
        URI uri = URI.create(url);
        if (uri.getQuery() == null) {
            return result;
        }
        for (String param : uri.getQuery().split("&")) {
            if (param == null) continue;
            String[] pair = param.split("=");
            if (pair.length > 1) {
                result.put(pair[0], pair[1]);
                continue;
            }
            result.put(pair[0], "");
        }
        return result;
    }

    public abstract Map<String, List<String>> getHeaders();

    public abstract Rectangle2D getBrowserSize();

    public abstract ReadOnlyBooleanProperty darkMode();

    public abstract boolean isDarkMode();

    public abstract ReadOnlyDoubleProperty devicePixelRatio();

    public abstract double getDevicePixelRatio();

    public abstract String getInstanceID();

    public abstract String getServer();

    public abstract void addInstanceCloseListener(InstanceCloseListener var1);

    public abstract void removeInstanceCloseListener(InstanceCloseListener var1);

    public abstract void loadJSFile(URL var1);

    public abstract void loadCSSFile(URL var1);

    public abstract JS js();

    @Deprecated
    public abstract void executeScript(String var1);

    public abstract String executeScriptWithReturn(String var1);

    public abstract String createUniqueJSName();

    public abstract String createUniqueJSName(String var1);

    @Deprecated
    public abstract JSVariable executeScriptWithVariable(String var1);

    @Deprecated
    public abstract void executeScriptWithListener(String var1, ScriptResultListener var2);

    @Deprecated
    public abstract CompletableFuture<String> executeScriptWithFuture(String var1);

    public abstract String createPublicFile(URL var1);

    public abstract void downloadURL(URL var1);

    public abstract void downloadURL(URL var1, Runnable var2);

    public abstract void downloadResource(String var1);

    public abstract void downloadResource(String var1, Runnable var2);

    public abstract void openLocalURL(URL var1);

    public abstract void openLocalResource(String var1);

    @Deprecated
    public abstract void registerValue(String var1, Node var2);

    @Deprecated
    public abstract void registerValue(String var1, String var2);

    public abstract JSVariable getElement(Node var1);

    public abstract JSVariable getHTMLViewElement(HTMLView var1);

    @Experimental
    public abstract JSVariable wrapNode(String var1, Node var2);

    @Experimental
    public abstract void loadNode(Node var1);

    public abstract void registerJavaFunction(String var1, WebCallback var2);

    public abstract JSVariable registerJavaFunction(WebCallback var1);

    public abstract JSVariable registerJavaFunctionWithVariable(Consumer<JSVariable> var1);

    public abstract CompletableFuture<JSVariable> executeJSAsync(String var1);

    public abstract JSVariable executeJSAsyncPromise(String var1);

    public abstract void layoutRoot(Scene var1);

    @Deprecated
    public abstract void requestLayout(Scene var1);

    public abstract void openURL(String var1);

    public abstract String registerWindow(Window var1);

    public abstract void openURLAsTab(String var1);

    public abstract void openURLAsPopup(String var1);

    public abstract void openStageAsPopup(Stage var1) throws IllegalStateException;

    public abstract void openStageAsTab(Stage var1) throws IllegalStateException;

    public abstract void openStageAsTab(Stage var1, String var2) throws IllegalStateException;

    public abstract void runAfterUpdate(Runnable var1);

    public abstract MultiFileUploader makeMultiFileUploadNode(Node var1);

    public abstract FileUploader makeFileUploadNode(Node var1);

    public abstract JSFile createJSFile(String var1, String var2, long var3);

    public abstract void setLossless(Image var1, boolean var2);

    public static FileUploader makeFileUploadNodeStatic(Node node) {
        return webAPIStaticImpl.makeFileUploadNodeStatic(node);
    }

    public static MultiFileUploader makeMultiFileUploadNodeStatic(Node node) {
        return webAPIStaticImpl.makeMultiFileUploadNodeStatic(node);
    }

    public static void setLosslessStatic(Image image, boolean value) {
        webAPIStaticImpl.setLosslessStatic(image, value);
    }

    public static Image createVirtualImage(String url, int w, int h) {
        return webAPIStaticImpl.createVirtualImage(url, w, h);
    }

    public static Image createVirtualImage(String url, int w, int h, boolean jproServerAsProxy) {
        return webAPIStaticImpl.createVirtualImage(url, w, h, jproServerAsProxy);
    }

    public abstract void closeInstance();

    public static ServerInfo getServerInfo() {
        return webAPIStaticImpl.getServerInfo();
    }

    public static interface WebAPIStatic {
        public FileUploader makeFileUploadNodeStatic(Node var1);

        public MultiFileUploader makeMultiFileUploadNodeStatic(Node var1);

        public void setLosslessStatic(Image var1, boolean var2);

        public Image createVirtualImage(String var1, int var2, int var3);

        public Image createVirtualImage(String var1, int var2, int var3, boolean var4);

        public ServerInfo getServerInfo();
    }

    public static abstract class FileUploader
    implements SingleFileUploader {
    }

    public static interface MultiFileUploader
    extends FileSelector {
        public ObjectProperty<Consumer<List<JSFile>>> onFilesSelectedProperty();

        default public void setOnFilesSelected(Consumer<List<JSFile>> value) {
            this.onFilesSelectedProperty().setValue(value);
        }
    }

    public static interface JSFile {
        public String getFilename();

        public long getFileSize();

        public JSVariable getObjectURL();

        public ReadOnlyDoubleProperty progressProperty();

        public ReadOnlyObjectProperty<File> uploadedFileProperty();

        default public double getProgress() {
            return this.progressProperty().getValue();
        }

        default public File getUploadedFile() {
            return (File)this.uploadedFileProperty().getValue();
        }

        public void uploadFile();

        public CompletableFuture<File> getUploadedFileFuture();
    }

    public static interface FileSelector {
        public BooleanProperty selectFileOnDropProperty();

        public ReadOnlyBooleanProperty fileDragOverProperty();

        public ObservableList<String> getFilesDragOverTypes();

        public BooleanProperty selectFileOnClickProperty();

        default public boolean getFileDragOver() {
            return this.fileDragOverProperty().getValue();
        }

        default public void setSelectFileOnClick(Boolean value) {
            this.selectFileOnClickProperty().setValue(value);
        }

        default public boolean getSelectFileOnClick() {
            return this.selectFileOnClickProperty().getValue();
        }

        default public void setSelectFileOnDrop(Boolean value) {
            this.selectFileOnDropProperty().setValue(value);
        }

        default public boolean getSelectFileOnDrop() {
            return this.selectFileOnDropProperty().getValue();
        }

        public ObservableList<String> supportedExtensions();

        public ObjectProperty<SelectionMode> selectionModeProperty();

        default public SelectionMode getSelectionMode() {
            return (SelectionMode)this.selectionModeProperty().getValue();
        }

        default public void setSelectionMode(SelectionMode value) {
            this.selectionModeProperty().setValue((Object)value);
        }
    }

    public static interface SingleFileUploader
    extends FileSelector {
        public ReadOnlyStringProperty selectedFileProperty();

        public ReadOnlyIntegerProperty selectedFileSizeProperty();

        public ReadOnlyDoubleProperty progressProperty();

        public ReadOnlyObjectProperty<JSFile> jsFileProperty();

        public void uploadFile();

        public ReadOnlyObjectProperty<File> uploadedFileProperty();

        public ObjectProperty<FileSelectedListener> onFileSelectedProperty();

        public BooleanProperty shouldCreateObjectURLProperty();

        public ObjectProperty<JSVariable> objectURLProperty();

        default public File getUploadedFile() {
            return (File)this.uploadedFileProperty().getValue();
        }

        default public String getSelectedFile() {
            return this.selectedFileProperty().getValue();
        }

        default public int getSelectedFileSize() {
            return this.selectedFileSizeProperty().getValue();
        }

        default public double getProgress() {
            return this.progressProperty().getValue();
        }

        default public JSFile getJSFile() {
            return (JSFile)this.jsFileProperty().getValue();
        }

        default public FileSelectedListener getOnFileSelected() {
            return (FileSelectedListener)this.onFileSelectedProperty().getValue();
        }

        default public void setOnFileSelected(FileSelectedListener value) {
            this.onFileSelectedProperty().setValue((Object)value);
        }
    }

    @FunctionalInterface
    public static interface FileSelectedListener {
        public void handle(String var1);
    }
}

