/*
 * Decompiled with CFR 0.152.
 */
package com.jpro.webapi.server;

import com.jpro.webapi.annotation.Experimental;

@Experimental
public class Response {
    private final boolean empty;
    private byte[] body;
    private int statusCode = 200;
    private String mimeType;

    private Response() {
        this.empty = true;
    }

    public Response(byte[] body) {
        this.body = body;
        this.empty = false;
    }

    public Response(byte[] body, int statusCode) {
        this.body = body;
        this.statusCode = statusCode;
        this.empty = false;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public static Response empty() {
        return new Response();
    }

    public static Response of(byte[] body) {
        return new Response(body);
    }

    public static Response of(byte[] body, String mimeType) {
        Response response = new Response(body);
        response.mimeType = mimeType;
        return response;
    }

    public static Response of(byte[] body, String mimeType, int statusCode) {
        Response response = new Response(body);
        response.mimeType = mimeType;
        response.statusCode = statusCode;
        return response;
    }
}

