package com.jpro.webapi.server;

import com.jpro.webapi.annotation.Experimental;

import java.util.List;
import java.util.Map;

/**
 * Represents a request with properties such as path, URI, host, and method.
 * This is an abstract class that provides a blueprint for request implementations.
 *
 * @author Florian Kirmaier
 */
@Experimental
public abstract class Request {

    /**
     * Returns the path of the request.
     * The path typically represents the endpoint or resource requested.
     *
     * @return the path of the request
     */
    public abstract String getPath();

    /**
     * Returns the URI of the request.
     * The URI typically includes the scheme, host, and path.
     *
     * @return the URI of the request
     */
    public abstract String getURI();

    /**
     * Returns the host of the request.
     * The host typically represents the domain or IP address of the server.
     *
     * @return the host of the request
     */
    public abstract String getHost();

    /**
     * Returns the method of the request.
     * The method typically represents the HTTP method used (e.g., GET, POST, etc.).
     *
     * @return the method of the request
     */
    public abstract String getMethod();

    /**
     * Returns the headers of the request.
     *
     * @return an unmodifiable map from header name to list of values
     */
    public abstract Map<String, List<String>> getHeaders();

    /**
     * Returns the body of the request.
     *
     * @return the body of the request as a byte array
     */
    public abstract byte[] getBody();

    @Override
    public String toString() {
        return "Request{" +
                "path='" + getPath() + '\'' +
                ", uri='" + getURI() + '\'' +
                ", host='" + getHost() + '\'' +
                ", method='" + getMethod() + '\'' +
                '}';
    }
}
