/*
 * Decompiled with CFR 0.152.
 */
package com.jpro.webapi;

import com.jpro.webapi.JSVariable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class PromiseJSVariable
extends JSVariable {
    private final JSVariable jsVariable;

    public PromiseJSVariable(JSVariable jsVariable) {
        super(jsVariable.getWebAPI(), jsVariable.getName(), "", jsVariable.onComplete());
        this.jsVariable = jsVariable;
    }

    public CompletableFuture<String> getPromiseString() {
        return this.resolveVariable().thenCompose(JSVariable::getString);
    }

    public CompletableFuture<Void> onPromiseComplete() {
        return this.resolveVariable().thenAccept(JSVariable::getString);
    }

    public void onPromiseError(Consumer<Throwable> errorHandler) {
        ((CompletableFuture)this.resolveVariable().thenAccept(jsVariable -> jsVariable.onError(errorHandler))).whenComplete((result, error) -> {
            if (error != null) {
                errorHandler.accept((Throwable)error);
            }
        });
    }

    public CompletableFuture<JSVariable> resolveVariable() {
        return JSVariable.promiseToFuture(this.jsVariable.webAPI, this);
    }
}

