/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.Framebuffer;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.util.Logging;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.WritableByteChannel;
import java.text.MessageFormat;

class FramebufferY8
extends Framebuffer {
    private static final int BITS_TO_BYTES = 3;
    private final PlatformLogger logger = Logging.getJavaFXLogger();
    private final ByteBuffer bb;
    private final int width;
    private final int height;
    private final int bitDepth;
    private final int byteDepth;
    private ByteBuffer lineByteBuffer;
    private Buffer linePixelBuffer;

    FramebufferY8(ByteBuffer bb, int width, int height, int depth, boolean clear) {
        super(bb, width, height, depth, clear);
        this.bb = bb;
        this.width = width;
        this.height = height;
        this.bitDepth = depth;
        this.byteDepth = depth >>> 3;
        if (this.byteDepth != 4 && this.byteDepth != 2 && this.byteDepth != 1) {
            String msg = MessageFormat.format("Unsupported color depth: {0} bpp", this.bitDepth);
            this.logger.severe(msg);
            throw new IllegalArgumentException(msg);
        }
    }

    private void copyNextPixel(IntBuffer source, ByteBuffer target) {
        int pixel32 = source.get();
        int r = pixel32 >> 16 & 0xFF;
        int g = pixel32 >> 8 & 0xFF;
        int b = pixel32 & 0xFF;
        int y = (int)(0.2126f * (float)r + 0.7152f * (float)g + 0.0722f * (float)b);
        target.put((byte)y);
    }

    private void copyNextPixel(IntBuffer source, ShortBuffer target) {
        int pixel32 = source.get();
        int r = pixel32 >> 8 & 0xF800;
        int g = pixel32 >> 5 & 0x7E0;
        int b = pixel32 >> 3 & 0x1F;
        int pixel16 = r | g | b;
        target.put((short)pixel16);
    }

    @Override
    void write(WritableByteChannel out) throws IOException {
        this.bb.clear();
        switch (this.byteDepth) {
            case 1: {
                if (this.lineByteBuffer == null) {
                    this.lineByteBuffer = ByteBuffer.allocate(this.width * 1);
                    this.lineByteBuffer.order(ByteOrder.nativeOrder());
                    this.linePixelBuffer = this.lineByteBuffer.duplicate();
                }
                IntBuffer srcPixels = this.bb.asIntBuffer();
                ByteBuffer byteBuffer = (ByteBuffer)this.linePixelBuffer;
                for (int y = 0; y < this.height; ++y) {
                    byteBuffer.clear();
                    for (int x = 0; x < this.width; ++x) {
                        this.copyNextPixel(srcPixels, byteBuffer);
                    }
                    this.lineByteBuffer.clear();
                    out.write(this.lineByteBuffer);
                }
                break;
            }
            case 2: {
                if (this.lineByteBuffer == null) {
                    this.lineByteBuffer = ByteBuffer.allocate(this.width * 2);
                    this.lineByteBuffer.order(ByteOrder.nativeOrder());
                    this.linePixelBuffer = this.lineByteBuffer.asShortBuffer();
                }
                IntBuffer srcPixels = this.bb.asIntBuffer();
                ShortBuffer shortBuffer = (ShortBuffer)this.linePixelBuffer;
                for (int y = 0; y < this.height; ++y) {
                    shortBuffer.clear();
                    for (int x = 0; x < this.width; ++x) {
                        this.copyNextPixel(srcPixels, shortBuffer);
                    }
                    this.lineByteBuffer.clear();
                    out.write(this.lineByteBuffer);
                }
                break;
            }
            case 4: {
                out.write(this.bb);
                break;
            }
            default: {
                String msg = MessageFormat.format("byteDepth={0}", this.byteDepth);
                this.logger.severe(msg);
                throw new IllegalStateException(msg);
            }
        }
    }

    @Override
    void copyToBuffer(ByteBuffer out) {
        this.bb.clear();
        switch (this.byteDepth) {
            case 1: {
                if (this.lineByteBuffer == null) {
                    this.lineByteBuffer = ByteBuffer.allocate(this.width * 1);
                    this.lineByteBuffer.order(ByteOrder.nativeOrder());
                    this.linePixelBuffer = this.lineByteBuffer.duplicate();
                }
                IntBuffer srcPixels = this.bb.asIntBuffer();
                ByteBuffer byteBuffer = (ByteBuffer)this.linePixelBuffer;
                for (int y = 0; y < this.height; ++y) {
                    byteBuffer.clear();
                    for (int x = 0; x < this.width; ++x) {
                        this.copyNextPixel(srcPixels, byteBuffer);
                    }
                    this.lineByteBuffer.clear();
                    out.put(this.lineByteBuffer);
                }
                break;
            }
            case 2: {
                if (this.lineByteBuffer == null) {
                    this.lineByteBuffer = ByteBuffer.allocate(this.width * 2);
                    this.lineByteBuffer.order(ByteOrder.nativeOrder());
                    this.linePixelBuffer = this.lineByteBuffer.asShortBuffer();
                }
                IntBuffer srcPixels = this.bb.asIntBuffer();
                ShortBuffer shortBuffer = (ShortBuffer)this.linePixelBuffer;
                for (int y = 0; y < this.height; ++y) {
                    shortBuffer.clear();
                    for (int x = 0; x < this.width; ++x) {
                        this.copyNextPixel(srcPixels, shortBuffer);
                    }
                    this.lineByteBuffer.clear();
                    out.put(this.lineByteBuffer);
                }
                break;
            }
            case 4: {
                out.put(this.bb);
                break;
            }
            default: {
                String msg = MessageFormat.format("byteDepth={0}", this.byteDepth);
                this.logger.severe(msg);
                throw new IllegalStateException(msg);
            }
        }
    }

    public String toString() {
        return MessageFormat.format("{0}[width={1} height={2} depth={3} bb={4}]", this.getClass().getName(), this.width, this.height, this.bitDepth, this.bb);
    }
}

