/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.LinuxSystem;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

class LinuxAbsoluteInputCapabilities {
    private int value;
    private int minimum;
    private int maximum;
    private int fuzz;
    private int flat;
    private int resolution;

    LinuxAbsoluteInputCapabilities(int value, int maximum, int minimum, int fuzz, int flat, int resolution) {
        this.value = value;
        this.maximum = maximum;
        this.minimum = minimum;
        this.fuzz = fuzz;
        this.flat = flat;
        this.resolution = resolution;
    }

    private LinuxAbsoluteInputCapabilities(LinuxSystem system, LinuxSystem.InputAbsInfo info, long fd, int axis) {
        system.ioctl(fd, system.EVIOCGABS(axis), info.p);
        this.value = LinuxSystem.InputAbsInfo.getValue(info.p);
        this.minimum = LinuxSystem.InputAbsInfo.getMinimum(info.p);
        this.maximum = LinuxSystem.InputAbsInfo.getMaximum(info.p);
        this.fuzz = LinuxSystem.InputAbsInfo.getFuzz(info.p);
        this.flat = LinuxSystem.InputAbsInfo.getFlat(info.p);
        this.resolution = LinuxSystem.InputAbsInfo.getResolution(info.p);
    }

    static Map<Integer, LinuxAbsoluteInputCapabilities> getCapabilities(File devNode, BitSet axes) throws IOException {
        if (axes == null || axes.isEmpty()) {
            return null;
        }
        LinuxSystem system = LinuxSystem.getLinuxSystem();
        LinuxSystem.InputAbsInfo info = new LinuxSystem.InputAbsInfo();
        long fd = system.open(devNode.getPath(), 0);
        if (fd == -1L) {
            throw new IOException(system.getErrorMessage());
        }
        HashMap<Integer, LinuxAbsoluteInputCapabilities> caps = new HashMap<Integer, LinuxAbsoluteInputCapabilities>();
        int i = 0;
        while ((i = axes.nextSetBit(i)) != -1) {
            caps.put(i, new LinuxAbsoluteInputCapabilities(system, info, fd, i));
            ++i;
        }
        system.close(fd);
        return caps;
    }

    int getValue() {
        return this.value;
    }

    int getMinimum() {
        return this.minimum;
    }

    int getMaximum() {
        return this.maximum;
    }

    int getFuzz() {
        return this.fuzz;
    }

    int getFlat() {
        return this.flat;
    }

    int getResolution() {
        return this.resolution;
    }
}

