/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.freezedetector;

import java.time.Duration;
import java.util.function.BiConsumer;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;

public class FreezeDetector {
    Thread fxthread;
    Long lastUpdate;
    Integer counter = 0;

    public FreezeDetector() {
        this(Duration.ofSeconds(1L));
    }

    public FreezeDetector(Duration duration, BiConsumer<Thread, Duration> callback) {
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException("Can run only on the FX thread");
        }
        this.fxthread = Thread.currentThread();
        this.lastUpdate = System.currentTimeMillis();
        new AnimationTimer(){

            public void handle(long now) {
                FreezeDetector.this.lastUpdate = System.currentTimeMillis();
                FreezeDetector.this.counter = 1;
            }
        }.start();
        this.lastUpdate = System.currentTimeMillis();
        this.counter = 1;
        Thread t = new Thread(() -> {
            while (this.fxthread.getState() != Thread.State.TERMINATED) {
                long timeGone2;
                long now = System.currentTimeMillis();
                long timeGone = now - this.lastUpdate;
                try {
                    long toSleep = duration.toMillis() * (long)this.counter.intValue() - timeGone;
                    if (toSleep > 0L) {
                        Thread.sleep(toSleep);
                    }
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                if ((timeGone2 = System.currentTimeMillis() - this.lastUpdate) <= duration.toMillis() * (long)this.counter.intValue()) continue;
                this.counter = this.counter + 1;
                callback.accept(this.fxthread, Duration.ofMillis(timeGone2));
            }
        }, "FX-Freeze-Detector-Thread");
        t.start();
    }

    public FreezeDetector(Duration duration) {
        this(duration, (thread, timeGone) -> {
            System.out.println("Freeze detected for " + timeGone.toMillis() + "ms");
            System.out.println(" Thread: " + thread.getName());
            for (StackTraceElement element : thread.getStackTrace()) {
                System.out.println(" " + String.valueOf(element));
            }
        });
    }
}

