/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.internal.util;

public class PlatformUtils {
    private static final String os = System.getProperty("os.name");
    private static final String version = System.getProperty("os.version");
    private static final String arch = System.getProperty("os.arch");
    private static final String javafxPlatform = System.getProperty("javafx.platform");
    private static final boolean embedded = Boolean.getBoolean("com.sun.javafx.isEmbedded");
    private static final boolean ANDROID = "android".equals(javafxPlatform) || "Dalvik".equals(System.getProperty("java.vm.name"));
    private static final boolean WINDOWS = os.startsWith("Windows");
    private static final boolean MAC = os.startsWith("Mac");
    private static final boolean LINUX = os.startsWith("Linux") && !ANDROID;
    private static final boolean IOS = os.startsWith("iOS");

    public static boolean isDesktop() {
        return PlatformUtils.isWindows() || PlatformUtils.isMac() || PlatformUtils.isLinux();
    }

    public static boolean isWindows() {
        return WINDOWS;
    }

    public static boolean isMac() {
        return MAC;
    }

    public static boolean isLinux() {
        return LINUX;
    }

    public static boolean isEmbedded() {
        return embedded;
    }

    public static boolean isAndroid() {
        return ANDROID;
    }

    public static boolean isIOS() {
        return IOS;
    }

    public static boolean isAarch64() {
        return arch.equals("aarch64");
    }

    private static boolean versionNumberGreaterThanOrEqualTo(float value) {
        try {
            return Float.parseFloat(version) >= value;
        }
        catch (Exception e) {
            return false;
        }
    }
}

