/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.cssfx.impl.log;

import java.io.PrintStream;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;

public class CSSFXLogger {
    private static final Clock clock = Clock.systemDefaultZone();
    private static final Logger CONSOLE_LOGGER = new Logger(){

        private void printLastThrowableArgument(PrintStream output, Object ... args) {
            if (args.length > 0 && Throwable.class.isAssignableFrom(args[args.length - 1].getClass())) {
                Throwable t = (Throwable)args[args.length - 1];
                t.printStackTrace(output);
            }
        }

        @Override
        public void log(LogLevel askedLevel, String message, Object ... args) {
            if (askedLevel.ordinal() <= logLevel.ordinal()) {
                ArrayList<Object> params = new ArrayList<Object>(args.length + 2);
                params.add(clock.instant());
                params.add((Object)askedLevel);
                params.addAll(Arrays.asList(args));
                PrintStream writer = LogLevel.ERROR.equals((Object)askedLevel) ? System.err : System.out;
                writer.println(String.format("%s [%5s] " + message, params.toArray()));
                this.printLastThrowableArgument(writer, args);
            }
        }
    };
    private static final LoggerFactory JUL_LOGGER_FACTORY = new LoggerFactory(){
        Map<LogLevel, Level> levelMapping = new HashMap<LogLevel, Level>(){
            {
                this.put(LogLevel.NONE, Level.OFF);
                this.put(LogLevel.ERROR, Level.SEVERE);
                this.put(LogLevel.WARN, Level.WARNING);
                this.put(LogLevel.INFO, Level.INFO);
                this.put(LogLevel.DEBUG, Level.FINE);
            }
        };

        @Override
        public Logger getLogger(String loggerName) {
            final java.util.logging.Logger delegate = java.util.logging.Logger.getLogger(loggerName);
            return new Logger(){

                @Override
                public void log(LogLevel askedLevel, String message, Object ... args) {
                    Level julLevel = levelMapping.get((Object)askedLevel);
                    Supplier<String> log = () -> String.format(message, args);
                    if (args.length > 0 && Throwable.class.isAssignableFrom(args[args.length - 1].getClass())) {
                        Throwable t = (Throwable)args[args.length - 1];
                        delegate.log(julLevel, t, log);
                    } else {
                        delegate.log(julLevel, log);
                    }
                }
            };
        }
    };
    private static final LoggerFactory CONSOLE_LOGGER_FACTORY = s -> CONSOLE_LOGGER;
    private static final Logger NOOP_LOGGER = (level, message, args) -> {};
    private static final LoggerFactory NOOP_LOGGER_FACTORY = s -> NOOP_LOGGER;
    private static LoggerFactory loggerFactory = null;
    private static LogLevel logLevel = LogLevel.INFO;

    public static void setLoggerFactory(LoggerFactory factory) {
        loggerFactory = factory;
    }

    public static boolean isInitialized() {
        return loggerFactory != null;
    }

    public static void setLogLevel(LogLevel newLevel) {
        logLevel = newLevel;
    }

    public static void console() {
        loggerFactory = CONSOLE_LOGGER_FACTORY;
    }

    public static void jul() {
        loggerFactory = JUL_LOGGER_FACTORY;
    }

    public static void noop() {
        loggerFactory = NOOP_LOGGER_FACTORY;
    }

    public static Logger logger(String loggerName) {
        if (!CSSFXLogger.isInitialized()) {
            CSSFXLogger.noop();
        }
        return loggerFactory.getLogger(loggerName);
    }

    public static Logger logger(Class<?> loggerClass) {
        if (!CSSFXLogger.isInitialized()) {
            CSSFXLogger.noop();
        }
        return loggerFactory.getLogger(loggerClass);
    }

    @FunctionalInterface
    public static interface LoggerFactory {
        default public Logger getLogger(Class<?> loggerClass) {
            return this.getLogger(loggerClass.getName());
        }

        public Logger getLogger(String var1);
    }

    @FunctionalInterface
    public static interface Logger {
        public void log(LogLevel var1, String var2, Object ... var3);

        default public void info(String message, Object ... args) {
            this.log(LogLevel.INFO, message, args);
        }

        default public void debug(String message, Object ... args) {
            this.log(LogLevel.DEBUG, message, args);
        }

        default public void warn(String message, Object ... args) {
            this.log(LogLevel.WARN, message, args);
        }

        default public void error(String message, Object ... args) {
            this.log(LogLevel.ERROR, message, args);
        }
    }

    public static enum LogLevel {
        NONE,
        ERROR,
        WARN,
        INFO,
        DEBUG;

    }
}

