/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.mutable.primitive;

import java.util.stream.DoubleStream;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.factory.bag.primitive.MutableDoubleBagFactory;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.factory.primitive.DoubleBags;
import org.eclipse.collections.impl.utility.Iterate;

public class MutableDoubleBagFactoryImpl
implements MutableDoubleBagFactory {
    public static final MutableDoubleBagFactory INSTANCE = new MutableDoubleBagFactoryImpl();

    public MutableDoubleBag empty() {
        return new DoubleHashBag();
    }

    public MutableDoubleBag of() {
        return this.empty();
    }

    public MutableDoubleBag with() {
        return this.empty();
    }

    public MutableDoubleBag of(double ... items) {
        return this.with(items);
    }

    public MutableDoubleBag with(double ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        return DoubleHashBag.newBagWith(items);
    }

    public MutableDoubleBag ofAll(DoubleIterable items) {
        return this.withAll(items);
    }

    public MutableDoubleBag withAll(DoubleIterable items) {
        return DoubleHashBag.newBag(items);
    }

    public MutableDoubleBag ofAll(Iterable<Double> iterable) {
        return this.withAll(iterable);
    }

    public MutableDoubleBag withAll(Iterable<Double> iterable) {
        return Iterate.collectDouble(iterable, Double::doubleValue, DoubleBags.mutable.empty());
    }

    public MutableDoubleBag ofAll(DoubleStream items) {
        return this.withAll(items);
    }

    public MutableDoubleBag withAll(DoubleStream items) {
        return this.with(items.toArray());
    }
}

