/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.factory.set.primitive.MutableShortSetFactory;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.impl.factory.primitive.ShortSets;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.impl.utility.Iterate;

public class MutableShortSetFactoryImpl
implements MutableShortSetFactory {
    public static final MutableShortSetFactory INSTANCE = new MutableShortSetFactoryImpl();

    public MutableShortSet empty() {
        return new ShortHashSet();
    }

    public MutableShortSet of() {
        return this.empty();
    }

    public MutableShortSet with() {
        return this.empty();
    }

    public MutableShortSet withInitialCapacity(int capacity) {
        return new ShortHashSet(capacity);
    }

    public MutableShortSet of(short ... items) {
        return this.with(items);
    }

    public MutableShortSet with(short ... items) {
        if (items == null || items.length == 0) {
            return this.empty();
        }
        return ShortHashSet.newSetWith(items);
    }

    public MutableShortSet ofAll(ShortIterable items) {
        return this.withAll(items);
    }

    public MutableShortSet withAll(ShortIterable items) {
        return ShortHashSet.newSet(items);
    }

    public MutableShortSet ofAll(Iterable<Short> iterable) {
        return this.withAll(iterable);
    }

    public MutableShortSet withAll(Iterable<Short> iterable) {
        return Iterate.collectShort(iterable, Short::shortValue, ShortSets.mutable.empty());
    }
}

