/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.LinuxAbsoluteInputCapabilities;
import com.sun.glass.ui.monocle.LinuxInput;
import com.sun.glass.ui.monocle.LinuxInputDevice;
import com.sun.glass.ui.monocle.LinuxInputProcessor;
import com.sun.glass.ui.monocle.NativePlatform;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.SysFS;
import com.sun.glass.ui.monocle.Udev;
import com.sun.glass.ui.monocle.UdevListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

class GetEvent {
    private static Set<File> devices = new HashSet<File>();
    private static UdevListener udevListener = (action, event) -> {
        String subsystem = (String)event.get("SUBSYSTEM");
        String devPath = (String)event.get("DEVPATH");
        if (subsystem != null && subsystem.equals("input") && devPath != null) {
            System.out.format("%1$ts.%1$tL Received UEVENT:\n", new Date());
            ArrayList keys = new ArrayList(event.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                System.out.format("  %s='%s'\n", key, event.get(key));
            }
            try {
                File sysPath = new File("/sys", devPath);
                String devNode = (String)event.get("DEVNAME");
                if (devNode == null) {
                    return;
                }
                if (action.equals("add") || action.equals("change") && !devices.contains(sysPath)) {
                    LinuxInputDevice device = new LinuxInputDevice(new File(devNode), sysPath, event);
                    device.setInputProcessor(new LinuxInputProcessor.Logger());
                    Thread thread = new Thread(device);
                    thread.setName(devNode.toString());
                    thread.setDaemon(true);
                    thread.start();
                    System.out.println("Added device " + devNode);
                    System.out.println("  touch=" + device.isTouch());
                    System.out.println("  multiTouch=" + device.isMultiTouch());
                    System.out.println("  relative=" + device.isRelative());
                    System.out.println("  5-way=" + device.is5Way());
                    System.out.println("  fullKeyboard=" + device.isFullKeyboard());
                    System.out.println("  PRODUCT=" + device.getProduct());
                    for (short axis = 0; axis < 63; axis = (short)(axis + 1)) {
                        LinuxAbsoluteInputCapabilities caps = device.getAbsoluteInputCapabilities(axis);
                        if (caps == null) continue;
                        String axisName = LinuxInput.codeToString("EV_ABS", axis);
                        System.out.format("  ABSVAL %s %d\n", axisName, caps.getValue());
                        System.out.format("  ABSMIN %s %d\n", axisName, caps.getMinimum());
                        System.out.format("  ABSMAX %s %d\n", axisName, caps.getMaximum());
                        System.out.format("  ABSFUZZ %s %d\n", axisName, caps.getFuzz());
                        System.out.format("  ABSFLAT %s %d\n", axisName, caps.getFlat());
                        System.out.format("  ABSRES %s %d\n", axisName, caps.getResolution());
                    }
                    devices.add(sysPath);
                } else if (action.equals("remove")) {
                    devices.remove(sysPath);
                }
            }
            catch (IOException | RuntimeException e) {
                e.printStackTrace();
            }
        }
    };

    GetEvent() {
    }

    public static void main(String[] argv) throws Exception {
        NativePlatform platform = NativePlatformFactory.getNativePlatform();
        Udev.getInstance().addListener(udevListener);
        SysFS.triggerUdevNotification("input");
        new Thread(platform.getRunnableProcessor()).start();
    }
}

