/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.HeadlessScreen;
import com.sun.glass.ui.monocle.MouseInput;
import com.sun.glass.ui.monocle.MouseState;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import javafx.application.Platform;

class VNCScreen
extends HeadlessScreen {
    private ServerSocketChannel server;
    private Set<ClientConnection> clients = new HashSet<ClientConnection>();

    VNCScreen() {
        super(1024, 600, 32);
        try {
            this.server = ServerSocketChannel.open();
            int vncPort = AccessController.doPrivileged(() -> Integer.getInteger("vnc.port", 5901));
            this.server.bind(new InetSocketAddress(vncPort));
            Thread t = new Thread(new ConnectionAccepter());
            t.setDaemon(true);
            t.setName("VNC Server on port " + vncPort);
            t.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
        for (ClientConnection cc : this.clients) {
            try {
                cc.socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapBuffers() {
        ClientConnection[] clientConnectionArray = this.clients;
        synchronized (this.clients) {
            ClientConnection[] ccs = this.clients.toArray(new ClientConnection[this.clients.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (ClientConnection cc : ccs) {
                try {
                    this.sendBuffer(cc.socket);
                }
                catch (IOException e) {
                    this.clients.remove(cc);
                }
            }
            super.swapBuffers();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClient(ClientConnection cc, IOException e) {
        Set<ClientConnection> set = this.clients;
        synchronized (set) {
            if (this.clients.contains(cc)) {
                System.out.format("Disconnecting %s: %s\n", cc.descriptor, e.getMessage());
                this.clients.remove(cc);
            }
        }
    }

    private void sendBuffer(WritableByteChannel out) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.put((byte)0);
        buffer.put((byte)0);
        buffer.putShort((short)1);
        buffer.putShort((short)0);
        buffer.putShort((short)0);
        buffer.putShort((short)this.width);
        buffer.putShort((short)this.height);
        buffer.putInt(0);
        buffer.flip();
        out.write(buffer);
        this.fb.write(out);
    }

    private class ConnectionAccepter
    implements Runnable {
        private ConnectionAccepter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ByteBuffer buffer = ByteBuffer.allocate(64);
            buffer.order(ByteOrder.BIG_ENDIAN);
            while (true) {
                try {
                    while (true) {
                        SocketChannel client = VNCScreen.this.server.accept();
                        System.out.format("Connection received from %s\n", client.getRemoteAddress());
                        buffer.clear();
                        buffer.put("RFB 003.003\n".getBytes());
                        buffer.flip();
                        client.write(buffer);
                        buffer.clear();
                        buffer.limit(12);
                        client.read(buffer);
                        buffer.flip();
                        System.out.format("Client supports %s\n", Charset.forName("UTF-8").decode(buffer).toString().trim());
                        buffer.clear();
                        buffer.putInt(1);
                        buffer.flip();
                        client.write(buffer);
                        buffer.clear();
                        buffer.limit(1);
                        client.read(buffer);
                        System.out.format("Client share request: %d\n", buffer.get(0));
                        buffer.clear();
                        buffer.putShort((short)VNCScreen.this.width);
                        buffer.putShort((short)VNCScreen.this.height);
                        buffer.put((byte)VNCScreen.this.depth);
                        buffer.put((byte)VNCScreen.this.depth);
                        buffer.put((byte)(!ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? 1 : 0));
                        buffer.put((byte)1);
                        if (VNCScreen.this.depth == 32) {
                            buffer.putShort((short)255);
                            buffer.putShort((short)255);
                            buffer.putShort((short)255);
                            buffer.put((byte)16);
                            buffer.put((byte)8);
                            buffer.put((byte)0);
                        } else {
                            buffer.putShort((short)31);
                            buffer.putShort((short)63);
                            buffer.putShort((short)31);
                            buffer.put((byte)11);
                            buffer.put((byte)5);
                            buffer.put((byte)0);
                        }
                        buffer.put((byte)0);
                        buffer.put((byte)0);
                        buffer.put((byte)0);
                        String name = "JavaFX on " + String.valueOf(client.getLocalAddress());
                        buffer.putInt(name.length());
                        buffer.put(name.getBytes());
                        buffer.flip();
                        client.write(buffer);
                        ClientConnection cc = new ClientConnection();
                        cc.socket = client;
                        Thread t = new Thread(cc);
                        t.setDaemon(true);
                        t.setName("VNC client connection from " + String.valueOf(client.getRemoteAddress()));
                        t.start();
                        Set<ClientConnection> set = VNCScreen.this.clients;
                        synchronized (set) {
                            VNCScreen.this.clients.add(cc);
                        }
                        VNCScreen.this.sendBuffer(client);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    private class ClientConnection
    implements Runnable {
        private SocketChannel socket;
        private String descriptor;

        private ClientConnection() {
        }

        @Override
        public void run() {
            ByteBuffer buffer = ByteBuffer.allocate(32);
            buffer.order(ByteOrder.BIG_ENDIAN);
            try {
                this.descriptor = this.socket.getRemoteAddress().toString();
                block11: while (true) {
                    buffer.clear();
                    buffer.limit(4);
                    this.socket.read(buffer);
                    switch (buffer.get(0)) {
                        case 0: {
                            buffer.clear();
                            buffer.limit(16);
                            this.socket.read(buffer);
                            continue block11;
                        }
                        case 1: {
                            buffer.clear();
                            buffer.limit(2);
                            this.socket.read(buffer);
                            int colorMapEntryCount = buffer.getShort(0);
                            int i = 0;
                            while (true) {
                                if (i >= colorMapEntryCount) continue block11;
                                buffer.clear();
                                buffer.limit(6);
                                this.socket.read(buffer);
                                ++i;
                            }
                        }
                        case 2: {
                            int encodingCount = buffer.getShort(2);
                            for (int i = 0; i < encodingCount; ++i) {
                                buffer.clear();
                                buffer.limit(4);
                                this.socket.read(buffer);
                            }
                        }
                        case 3: {
                            buffer.clear();
                            buffer.limit(6);
                            this.socket.read(buffer);
                            Platform.runLater(() -> {
                                try {
                                    if (!VNCScreen.this.fb.hasReceivedData()) {
                                        VNCScreen.this.sendBuffer(this.socket);
                                    }
                                }
                                catch (IOException e) {
                                    VNCScreen.this.removeClient(this, e);
                                }
                            });
                            continue block11;
                        }
                        case 4: {
                            buffer.clear();
                            buffer.limit(4);
                            this.socket.read(buffer);
                            continue block11;
                        }
                        case 5: {
                            short x = buffer.getShort(2);
                            buffer.position(1);
                            buffer.limit(2);
                            BitSet buttons = BitSet.valueOf(buffer);
                            buffer.clear();
                            buffer.limit(2);
                            this.socket.read(buffer);
                            short y = buffer.getShort(0);
                            MouseState state = new MouseState();
                            state.setX(x);
                            state.setY(y);
                            if (buttons.get(0)) {
                                state.pressButton(212);
                            }
                            if (buttons.get(1)) {
                                state.pressButton(214);
                            }
                            if (buttons.get(2)) {
                                state.pressButton(213);
                            }
                            if (buttons.get(3)) {
                                state.setWheel(1);
                            }
                            if (buttons.get(4)) {
                                state.setWheel(-1);
                            }
                            if (buttons.get(5)) {
                                state.pressButton(215);
                            }
                            if (buttons.get(6)) {
                                state.pressButton(216);
                            }
                            Platform.runLater(() -> MouseInput.getInstance().setState(state, false));
                            continue block11;
                        }
                        case 6: {
                            buffer.clear();
                            buffer.limit(4);
                            this.socket.read(buffer);
                            int textLength = buffer.getInt(0);
                            int i = 0;
                            while (true) {
                                if (i >= textLength) continue block11;
                                buffer.clear();
                                buffer.limit(1);
                                this.socket.read(buffer);
                                ++i;
                            }
                        }
                    }
                    System.err.format("Unknown message %d from client %s\n", buffer.get(0), this.socket.getRemoteAddress());
                }
            }
            catch (IOException e) {
                VNCScreen.this.removeClient(this, e);
                return;
            }
        }
    }
}

