/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.authentication;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import one.jpro.platform.auth.core.authentication.Authentication;
import one.jpro.platform.auth.core.authentication.AuthenticationException;
import one.jpro.platform.auth.core.utils.AuthUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.json.JSONObject;

public class User
implements Authentication {
    @NotNull
    private final String name;
    @NotNull
    private final Set<String> roles;
    @NotNull
    private final Map<String, Object> attributes;

    public User(@NotNull String name) {
        this(name, null, null);
    }

    public User(@NotNull String name, @Nullable Set<String> roles) {
        this(name, roles, null);
    }

    public User(@NotNull String name, @Nullable Map<String, Object> attributes) {
        this(name, null, attributes);
    }

    public User(@NotNull String name, @Nullable Set<String> roles, @Nullable Map<String, Object> attributes) {
        Objects.requireNonNull(name, "User's name is null.");
        this.name = name;
        this.roles = roles == null || roles.isEmpty() ? Collections.emptySet() : roles;
        this.attributes = attributes == null ? Collections.emptyMap() : attributes;
    }

    public User(@NotNull JSONObject json) {
        String username = json.optString("name");
        if ((username == null || username.isBlank()) && ((username = json.optString("username")) == null || username.isBlank())) {
            throw new AuthenticationException("User's name is null.");
        }
        this.name = username;
        this.roles = json.has("roles") ? json.getJSONArray("roles").toList().stream().map(Object::toString).collect(Collectors.toUnmodifiableSet()) : Collections.emptySet();
        this.attributes = json.has("attributes") ? json.getJSONObject("attributes").toMap() : Collections.emptyMap();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public @Unmodifiable Set<String> getRoles() {
        return Collections.unmodifiableSet(this.roles);
    }

    @Override
    @NotNull
    public @Unmodifiable Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public boolean hasRole(String role) {
        return this.getRoles().contains(role);
    }

    public boolean hasAttribute(String key) {
        return this.hasKey(this.toJSON().getJSONObject("attributes"), key);
    }

    private boolean hasKey(JSONObject json, String key) {
        boolean exists = json.has(key);
        if (!exists) {
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String nextKey = (String)keys.next();
                if (!(json.get(nextKey) instanceof JSONObject)) continue;
                exists = this.hasKey(json.getJSONObject(nextKey), key);
            }
        }
        return exists;
    }

    public Optional<String> getAttribute(String key) {
        Object value = AuthUtils.findValueByKey(this.toJSON().getJSONObject("attributes"), key);
        return Optional.ofNullable(value).map(Object::toString);
    }

    public String getEmail() {
        return this.getAttribute("email").orElseThrow();
    }
}

