/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.jwt;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import one.jpro.platform.auth.core.http.HttpMethod;
import one.jpro.platform.auth.core.jwt.JWTAuthOptions;
import one.jpro.platform.auth.core.utils.AuthUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

public class JWTAuthAPI {
    @NotNull
    private final JWTAuthOptions options;
    @NotNull
    private final HttpClient httpClient;

    public JWTAuthAPI(@NotNull JWTAuthOptions options) {
        this.options = options;
        this.httpClient = HttpClient.newHttpClient();
    }

    public CompletableFuture<JSONObject> token(@NotNull String tokenPath, @NotNull JSONObject params) {
        String payload = new JSONObject(params.toString()).toString();
        JSONObject headers = new JSONObject();
        headers.put("Accept", (Object)"application/json,application/x-www-form-urlencoded;q=0.9");
        headers.put("Content-Type", (Object)"application/json");
        return this.fetch(HttpMethod.POST, tokenPath, headers, payload).thenCompose(response -> {
            JSONObject json;
            if (response.body() == null || ((String)response.body()).isEmpty()) {
                return CompletableFuture.failedFuture(new RuntimeException("No Body"));
            }
            HttpHeaders header = response.headers();
            if (AuthUtils.containsValue(header, "application/json")) {
                json = new JSONObject((String)response.body());
            } else if (AuthUtils.containsValue(header, "application/x-www-form-urlencoded") || AuthUtils.containsValue(header, "text/plain")) {
                json = AuthUtils.queryToJson((String)response.body());
            } else {
                return CompletableFuture.failedFuture(new RuntimeException("Cannot handle content type: " + header.map().get("Content-Type")));
            }
            if (json == null || json.has("error")) {
                return CompletableFuture.failedFuture(new RuntimeException(AuthUtils.extractErrorDescription(json)));
            }
            return CompletableFuture.completedFuture(json);
        });
    }

    private CompletableFuture<HttpResponse<String>> fetch(@NotNull HttpMethod method, @NotNull String path, @Nullable JSONObject headers, @NotNull String payload) {
        if (path == null || path.isEmpty()) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Invalid path"));
        }
        String url = path.charAt(0) == '/' ? this.options.getSite() + path : path;
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(url));
        if (headers != null) {
            for (Map.Entry kv : headers.toMap().entrySet()) {
                requestBuilder.header((String)kv.getKey(), (String)kv.getValue());
            }
        }
        if (method != HttpMethod.POST && method != HttpMethod.PATCH && method != HttpMethod.PUT) {
            payload = null;
        }
        return this.makeRequest(requestBuilder, payload);
    }

    private CompletableFuture<HttpResponse<String>> makeRequest(HttpRequest.Builder requestBuilder, String payload) {
        if (payload != null) {
            requestBuilder.POST(HttpRequest.BodyPublishers.ofByteArray(payload.getBytes()));
        }
        return this.httpClient.sendAsync(requestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenCompose(response -> {
            if (response.statusCode() < 200 || response.statusCode() >= 300) {
                JSONObject error;
                if (response.body() == null || ((String)response.body()).isEmpty()) {
                    return CompletableFuture.failedFuture(new RuntimeException("Status code: " + response.statusCode()));
                }
                if (AuthUtils.containsValue(response.headers(), "application/json") && !(error = new JSONObject((String)response.body())).optString("error").isEmpty()) {
                    if (!error.optString("error_description").isEmpty()) {
                        return CompletableFuture.failedFuture(new RuntimeException(error.getString("error") + ": " + error.getString("error_description")));
                    }
                    return CompletableFuture.failedFuture(new RuntimeException(error.getString("error")));
                }
                return CompletableFuture.failedFuture(new RuntimeException(response.statusCode() + ": " + (String)response.body()));
            }
            return CompletableFuture.completedFuture(response);
        });
    }
}

