/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.jwt;

import com.auth0.jwt.JWT;
import com.auth0.jwt.exceptions.JWTDecodeException;
import java.util.Base64;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import one.jpro.platform.auth.core.authentication.AuthenticationException;
import one.jpro.platform.auth.core.authentication.AuthenticationProvider;
import one.jpro.platform.auth.core.authentication.CredentialValidationException;
import one.jpro.platform.auth.core.authentication.User;
import one.jpro.platform.auth.core.jwt.JWTAuthAPI;
import one.jpro.platform.auth.core.jwt.JWTAuthOptions;
import one.jpro.platform.auth.core.jwt.JWTOptions;
import one.jpro.platform.auth.core.jwt.TokenCredentials;
import one.jpro.platform.auth.core.utils.AuthUtils;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTAuthenticationProvider
implements AuthenticationProvider<TokenCredentials> {
    private static final Logger logger = LoggerFactory.getLogger(JWTAuthenticationProvider.class);
    private static final Base64.Decoder BASE64_DECODER = AuthUtils.BASE64_DECODER;
    @NotNull
    private final JWTAuthOptions authOptions;
    @NotNull
    private final JWTOptions options;
    @NotNull
    private final JWTAuthAPI api;

    public JWTAuthenticationProvider(@NotNull JWTAuthOptions authOptions) {
        this.authOptions = Objects.requireNonNull(authOptions, "JWT authentication options cannot be null");
        this.options = Objects.requireNonNull(authOptions.getJWTOptions(), "JWT options cannot be null");
        this.api = new JWTAuthAPI(authOptions);
    }

    public CompletableFuture<TokenCredentials> token(@NotNull String tokenPath, @NotNull JSONObject authInfo) {
        logger.debug("Requesting token from: {}, and authentication info: {}", (Object)(this.authOptions.getSite() + tokenPath), (Object)authInfo);
        return this.api.token(tokenPath, authInfo).thenCompose(json -> {
            logger.info("Received token: {}", json);
            if (json.has("token")) {
                return CompletableFuture.completedFuture(new TokenCredentials(json.getString("token")));
            }
            return CompletableFuture.failedFuture(new AuthenticationException("Invalid JWT token"));
        });
    }

    @Override
    public CompletableFuture<User> authenticate(@NotNull TokenCredentials credentials) {
        JSONObject payload;
        try {
            credentials.validate(null);
        }
        catch (CredentialValidationException ex) {
            logger.error("JWT token validation failed", (Throwable)ex);
            return CompletableFuture.failedFuture(ex);
        }
        try {
            String encodedJwtPayload = JWT.decode((String)credentials.getToken()).getPayload();
            String decodedJwtPayload = new String(BASE64_DECODER.decode(encodedJwtPayload));
            payload = new JSONObject(decodedJwtPayload);
        }
        catch (JWTDecodeException ex) {
            logger.error("JWT token decoding failed", (Throwable)ex);
            return CompletableFuture.failedFuture(ex);
        }
        if (this.options.getAudience() != null && payload.has("aud")) {
            JSONArray target = payload.get("aud") instanceof String ? new JSONArray().put((Object)payload.getString("aud")) : payload.getJSONArray("aud");
            if (Collections.disjoint(this.options.getAudience(), target.toList())) {
                return CompletableFuture.failedFuture(new AuthenticationException("Invalid JWT audience, expected: " + new JSONObject(this.options.getAudience())));
            }
        }
        if (this.options.getIssuer() != null && payload.has("iss") && !this.options.getIssuer().equals(payload.getString("iss"))) {
            return CompletableFuture.failedFuture(new AuthenticationException("Invalid JWT issuer, expected: " + this.options.getIssuer()));
        }
        User user = this.createUser(credentials.getToken(), payload);
        return CompletableFuture.completedFuture(user);
    }

    private User createUser(@NotNull String token, @NotNull JSONObject payload) {
        Objects.requireNonNull(token, "token can not be null");
        Objects.requireNonNull(payload, "payload can not be null");
        JSONObject jwtJSON = new JSONObject().put("access_token", (Object)token);
        JSONObject accessTokenJSON = new JSONObject().put("token", (Object)token).put("token_type", (Object)"access_token");
        if (payload.has("amr")) {
            accessTokenJSON.put("amr", (Object)payload.getJSONArray("amr"));
        }
        if (payload.has("sub")) {
            accessTokenJSON.put("sub", (Object)payload.getString("sub"));
        }
        if (payload.has("exp")) {
            accessTokenJSON.put("exp", payload.getLong("exp"));
        }
        if (payload.has("iat")) {
            accessTokenJSON.put("iat", payload.getLong("iat"));
        }
        if (payload.has("nbf")) {
            accessTokenJSON.put("nbf", payload.getLong("nbf"));
        }
        jwtJSON.put("accessToken", (Object)accessTokenJSON);
        JSONObject userJSON = new JSONObject();
        if (payload.has("name")) {
            userJSON.put("name", (Object)payload.getString("name"));
        } else if (payload.has("username")) {
            userJSON.put("name", (Object)payload.getString("username"));
        } else if (payload.has("email")) {
            userJSON.put("name", (Object)payload.getString("email"));
        }
        if (payload.has("roles")) {
            userJSON.put("roles", (Object)payload.getJSONArray("roles"));
        } else if (payload.has("permissions")) {
            userJSON.put("roles", (Object)payload.getJSONArray("permissions"));
        } else if (payload.has("perms")) {
            userJSON.put("roles", (Object)payload.getJSONArray("perms"));
        }
        userJSON.put("attributes", (Object)new JSONObject().put("auth", (Object)jwtJSON));
        return new User(userJSON);
    }
}

