/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.jwt;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import one.jpro.platform.auth.core.authentication.Options;
import org.json.JSONObject;

public class JWTOptions
implements Options {
    private static final long DEFAULT_LEEWAY = 0L;
    private static final long DEFAULT_CACHE_SIZE = 5L;
    private static final Duration DEFAULT_EXPIRES_IN = Duration.ofHours(8L);
    private String issuer;
    private String subject;
    private List<String> audience;
    private List<String> claims;
    private long leeway = 0L;
    private boolean ignoreIssuedAt;
    private long cacheSize = 5L;
    private Duration expiresIn = DEFAULT_EXPIRES_IN;
    private String nonceAlgorithm;

    public JWTOptions() {
    }

    public JWTOptions(JWTOptions other) {
        this.issuer = other.issuer;
        this.subject = other.subject;
        this.audience = other.audience;
        this.claims = other.claims;
        this.leeway = other.leeway;
        this.ignoreIssuedAt = other.ignoreIssuedAt;
        this.cacheSize = other.cacheSize;
        this.expiresIn = other.expiresIn;
        this.nonceAlgorithm = other.nonceAlgorithm;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public JWTOptions setIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public JWTOptions setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public List<String> getAudience() {
        return this.audience;
    }

    public JWTOptions setAudience(List<String> audience) {
        this.audience = audience;
        return this;
    }

    public List<String> getClaims() {
        return this.claims;
    }

    public JWTOptions setClaims(List<String> claims) {
        this.claims = claims;
        return this;
    }

    public long getLeeway() {
        return this.leeway;
    }

    public JWTOptions setLeeway(long leeway) {
        this.leeway = leeway;
        return this;
    }

    public boolean isIgnoreIssuedAt() {
        return this.ignoreIssuedAt;
    }

    public JWTOptions setIgnoreIssuedAt(boolean ignoreIssuedAt) {
        this.ignoreIssuedAt = ignoreIssuedAt;
        return this;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public JWTOptions setCacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
        return this;
    }

    public Duration getExpiresIn() {
        return this.expiresIn;
    }

    public JWTOptions setExpiresIn(Duration expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    public String getNonceAlgorithm() {
        return this.nonceAlgorithm;
    }

    public JWTOptions setNonceAlgorithm(String nonceAlgorithm) {
        this.nonceAlgorithm = nonceAlgorithm;
        return this;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        Optional.ofNullable(this.getIssuer()).ifPresent(issuer -> json.put("issuer", issuer));
        Optional.ofNullable(this.getSubject()).ifPresent(subject -> json.put("subject", subject));
        Optional.ofNullable(this.getAudience()).ifPresent(audience -> json.put("audience", (Collection)audience));
        Optional.ofNullable(this.getClaims()).ifPresent(claims -> json.put("claims", (Collection)claims));
        json.put("leeway", this.getLeeway());
        json.put("ignore_issued_at", this.isIgnoreIssuedAt());
        json.put("cache_size", this.getCacheSize());
        json.put("expires_in", this.getExpiresIn().getSeconds());
        Optional.ofNullable(this.getNonceAlgorithm()).ifPresent(nonceAlgorithm -> json.put("nonceAlgorithm", nonceAlgorithm));
        return json;
    }
}

