/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.jwt;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.jpro.platform.auth.core.authentication.CredentialValidationException;
import one.jpro.platform.auth.core.authentication.Credentials;
import one.jpro.platform.auth.core.authentication.User;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

public class TokenCredentials
implements Credentials {
    @NotNull
    private String token;
    @Nullable
    private List<String> scopes;

    public static TokenCredentials fromJSON(String json) {
        return new TokenCredentials(new JSONObject(json));
    }

    public static String toJSON(TokenCredentials tokenCredentials) {
        return tokenCredentials.toJSON().toString();
    }

    public TokenCredentials(@NotNull String token) {
        this.token = token;
    }

    public TokenCredentials(@NotNull JSONObject json) {
        if (json == null) {
            throw new IllegalStateException("json object cannot be null");
        }
        this.token = json.optString("token");
        if (json.has("scope")) {
            this.addScopes(json.getString("scope"));
        } else if (json.has("scopes")) {
            JSONArray scopes = json.getJSONArray("scopes");
            this.setScopes(scopes.toList().stream().map(Object::toString).collect(Collectors.toList()));
        }
    }

    public TokenCredentials(@NotNull User user) {
        this(user.toJSON().optJSONObject("attributes").optJSONObject("auth", new JSONObject()).optJSONObject("accessToken"));
    }

    @NotNull
    public String getToken() {
        return this.token;
    }

    public TokenCredentials setToken(@NotNull String token) {
        this.token = token;
        return this;
    }

    @Nullable
    public List<String> getScopes() {
        return this.scopes;
    }

    public TokenCredentials setScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public TokenCredentials addScopes(String ... scopes) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.addAll(List.of(scopes));
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenCredentials that = (TokenCredentials)o;
        return this.token.equals(that.token) && Objects.equals(this.scopes, that.scopes);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.scopes);
    }

    @Override
    public <V> void validate(V arg) throws CredentialValidationException {
        if (this.token == null || this.token.isBlank()) {
            throw new CredentialValidationException("token cannot be null or blank");
        }
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        Optional.of(this.getToken()).ifPresent(token -> json.put("token", token));
        Optional.ofNullable(Stream.ofNullable(this.getScopes()).collect(Collector.of(JSONArray::new, JSONArray::putAll, JSONArray::putAll, new Collector.Characteristics[0]))).filter(scopes -> !scopes.isEmpty()).ifPresent(jsonArray -> json.put("scopes", jsonArray));
        return json;
    }

    @Override
    public String toHttpAuthorization() {
        return "Bearer " + this.token;
    }

    public String toString() {
        return this.toJSON().toString();
    }
}

