/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.oauth2;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.UrlJwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.jpro.webapi.WebAPI;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.security.interfaces.RSAPublicKey;
import java.time.Instant;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javafx.stage.Stage;
import one.jpro.platform.auth.core.authentication.AuthenticationException;
import one.jpro.platform.auth.core.authentication.AuthenticationProvider;
import one.jpro.platform.auth.core.authentication.CredentialValidationException;
import one.jpro.platform.auth.core.authentication.Credentials;
import one.jpro.platform.auth.core.authentication.User;
import one.jpro.platform.auth.core.basic.UsernamePasswordCredentials;
import one.jpro.platform.auth.core.http.HttpServer;
import one.jpro.platform.auth.core.jwt.JWTOptions;
import one.jpro.platform.auth.core.jwt.TokenCredentials;
import one.jpro.platform.auth.core.jwt.TokenExpiredException;
import one.jpro.platform.auth.core.oauth2.OAuth2API;
import one.jpro.platform.auth.core.oauth2.OAuth2Credentials;
import one.jpro.platform.auth.core.oauth2.OAuth2Flow;
import one.jpro.platform.auth.core.oauth2.OAuth2Options;
import one.jpro.platform.auth.core.oauth2.provider.OpenIDAuthenticationProvider;
import one.jpro.platform.auth.core.utils.AuthUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2AuthenticationProvider
implements AuthenticationProvider<Credentials> {
    private static final Logger logger = LoggerFactory.getLogger(OAuth2AuthenticationProvider.class);
    private static final Base64.Decoder BASE64_DECODER = AuthUtils.BASE64_DECODER;
    @Nullable
    private final Stage stage;
    @NotNull
    private final OAuth2API api;
    @NotNull
    private final OAuth2Options options;
    private HttpServer httpServer;

    public OAuth2AuthenticationProvider(@Nullable Stage stage, @NotNull OAuth2API api) {
        this.stage = stage;
        this.api = Objects.requireNonNull(api, "OAuth2 api cannot be null");
        this.options = api.getOptions();
        this.options.validate();
        this.httpServer = HttpServer.create(stage);
    }

    public OAuth2AuthenticationProvider(@Nullable Stage stage, @NotNull OAuth2Options options) {
        this(stage, new OAuth2API(options));
    }

    @NotNull
    public final OAuth2Options getOptions() {
        return this.options;
    }

    public CompletableFuture<String> authorizeUrl(@NotNull OAuth2Credentials credentials) {
        Objects.requireNonNull(credentials, "OAuth2Credentials cannot be null");
        String authorizeUrl = this.api.authorizeURL(credentials.setNormalizedRedirectUri(this.normalizeUri(credentials.getRedirectUri())));
        logger.debug("Authorize URL: {}", (Object)authorizeUrl);
        if (!WebAPI.isBrowser()) {
            if (this.httpServer != null) {
                this.httpServer.stop();
            }
            this.httpServer = HttpServer.create(this.stage);
        }
        return this.httpServer.openURL(authorizeUrl);
    }

    @Override
    public CompletableFuture<User> authenticate(@NotNull Credentials credentials) {
        try {
            if (credentials instanceof UsernamePasswordCredentials) {
                UsernamePasswordCredentials usernamePasswordCredentials = (UsernamePasswordCredentials)credentials;
                usernamePasswordCredentials.validate(null);
                OAuth2Credentials oauth2Credentials = new OAuth2Credentials().setUsername(usernamePasswordCredentials.getUsername()).setPassword(usernamePasswordCredentials.getPassword()).setFlow(OAuth2Flow.PASSWORD);
                return this.authenticate(oauth2Credentials);
            }
            if (credentials instanceof TokenCredentials) {
                TokenCredentials tokenCredentials = (TokenCredentials)credentials;
                tokenCredentials.validate(null);
                try {
                    User newUser = this.createUser(new JSONObject().put("access_token", (Object)tokenCredentials.getToken()));
                    return CompletableFuture.completedFuture(newUser);
                }
                catch (IllegalStateException | TokenExpiredException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                catch (JwkException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                if (this.options.getIntrospectionPath() == null) {
                    return CompletableFuture.failedFuture(new RuntimeException("Can't authenticate `access_token`: Provider doesn't support token introspection"));
                }
                return this.api.tokenIntrospection("access_token", tokenCredentials.getToken()).thenCompose(json -> {
                    String clientId;
                    if (json.has("active") && json.getBoolean("active")) {
                        return CompletableFuture.failedFuture(new RuntimeException("Inactive Token"));
                    }
                    if (json.has("client_id") && (clientId = this.options.getClientId()) != null && !clientId.equals(json.getString("client_id"))) {
                        logger.info("Introspect `client_id` doesn't match configured `client_id`");
                    }
                    try {
                        User newUser = this.createUser((JSONObject)json);
                        return CompletableFuture.completedFuture(newUser);
                    }
                    catch (IllegalStateException | TokenExpiredException ex) {
                        return CompletableFuture.failedFuture(ex);
                    }
                    catch (JwkException ex) {
                        return CompletableFuture.failedFuture(new RuntimeException(ex.getMessage(), ex));
                    }
                });
            }
            OAuth2Credentials oauth2Credentials = (OAuth2Credentials)credentials;
            JSONObject queryParams = new JSONObject(this.httpServer.getQueryParams());
            logger.debug("URL query parameters: {}", (Object)queryParams);
            if (queryParams.has("code")) {
                oauth2Credentials.setCode(queryParams.getString("code"));
                if (oauth2Credentials.getCode() == null || oauth2Credentials.getCode().isBlank()) {
                    return CompletableFuture.failedFuture(new RuntimeException("Authorization code is missing"));
                }
            }
            if (queryParams.has("scope")) {
                String[] scopes = queryParams.getString("scope").split("\\+");
                oauth2Credentials.setScopes(List.of(scopes));
            }
            JSONObject params = new JSONObject();
            OAuth2Flow flow = oauth2Credentials.getFlow() != null ? oauth2Credentials.getFlow() : this.options.getFlow();
            oauth2Credentials.validate(flow);
            if (this.options.getSupportedGrantTypes() != null && !this.options.getSupportedGrantTypes().isEmpty() && !this.options.getSupportedGrantTypes().contains(flow.getGrantType())) {
                return CompletableFuture.failedFuture(new RuntimeException("Provided flow is not supported by provider"));
            }
            switch (flow) {
                case AUTH_CODE: {
                    params.put("code", (Object)oauth2Credentials.getCode());
                    if (oauth2Credentials.getRedirectUri() != null) {
                        params.put("redirect_uri", (Object)this.normalizeUri(oauth2Credentials.getRedirectUri()));
                    }
                    if (oauth2Credentials.getCodeVerifier() == null) break;
                    params.put("code_verifier", (Object)oauth2Credentials.getCodeVerifier());
                    break;
                }
                case PASSWORD: {
                    params.put("username", (Object)oauth2Credentials.getUsername()).put("password", (Object)oauth2Credentials.getPassword());
                    if (oauth2Credentials.getScopes() == null) break;
                    params.put("scope", (Object)String.join((CharSequence)this.options.getScopeSeparator(), oauth2Credentials.getScopes()));
                    break;
                }
                case CLIENT: {
                    if (oauth2Credentials.getScopes() == null) break;
                    params.put("scope", (Object)String.join((CharSequence)this.options.getScopeSeparator(), oauth2Credentials.getScopes()));
                    break;
                }
                case AUTH_JWT: {
                    if (oauth2Credentials.getAssertion() != null) {
                        params.put("assertion", (Object)oauth2Credentials.getAssertion());
                    }
                    if (oauth2Credentials.getScopes() == null) break;
                    params.put("scope", (Object)String.join((CharSequence)this.options.getScopeSeparator(), oauth2Credentials.getScopes()));
                    break;
                }
                default: {
                    return CompletableFuture.failedFuture(new RuntimeException("Current flow does not allow acquiring a token by the replay party"));
                }
            }
            return this.api.token(flow.getGrantType(), params).thenCompose(json -> {
                try {
                    User newUser = this.createUser((JSONObject)json);
                    oauth2Credentials.setUsername(newUser.getName());
                    return CompletableFuture.completedFuture(newUser);
                }
                catch (IllegalStateException | TokenExpiredException ex) {
                    return CompletableFuture.failedFuture(ex);
                }
                catch (JwkException ex) {
                    return CompletableFuture.failedFuture(new RuntimeException(ex.getMessage(), ex));
                }
            });
        }
        catch (ClassCastException | CredentialValidationException ex) {
            return CompletableFuture.failedFuture(ex);
        }
    }

    public CompletableFuture<OpenIDAuthenticationProvider> discover() {
        return this.api.discover(this.stage, this.options);
    }

    public CompletableFuture<JSONObject> introspect(User user, String tokenType) {
        return this.api.tokenIntrospection(tokenType, user.toJSON().getJSONObject("attributes").optJSONObject("auth").get(tokenType).toString());
    }

    public CompletableFuture<User> refresh(User user) throws IllegalStateException {
        String refreshToken = user.toJSON().getJSONObject("attributes").optJSONObject("auth").optString("refresh_token");
        if (refreshToken == null || refreshToken.isBlank()) {
            return CompletableFuture.failedFuture(new IllegalStateException("refresh_token is null or missing"));
        }
        return this.api.token("refresh_token", new JSONObject().put("refresh_token", (Object)refreshToken)).thenCompose(json -> {
            try {
                User newUser = this.createUser((JSONObject)json);
                return CompletableFuture.completedFuture(newUser);
            }
            catch (IllegalStateException | TokenExpiredException ex) {
                return CompletableFuture.failedFuture(ex);
            }
            catch (JwkException ex) {
                return CompletableFuture.failedFuture(new RuntimeException(ex.getMessage(), ex));
            }
        });
    }

    public CompletableFuture<Void> revoke(User user, String tokenType) {
        return this.api.tokenRevocation(tokenType, user.toJSON().getJSONObject("attributes").optJSONObject("auth").get(tokenType).toString());
    }

    public CompletableFuture<JSONObject> userInfo(@NotNull User user) {
        Objects.requireNonNull(user, "User must not be null");
        JSONObject authJSON = user.toJSON().getJSONObject("attributes").getJSONObject("auth");
        return this.api.userInfo(authJSON.getString("access_token")).thenCompose(json -> {
            String userSub;
            JSONObject accessTokenJSON = authJSON.optJSONObject("accessToken");
            if (accessTokenJSON != null && accessTokenJSON.has("sub") && !(userSub = accessTokenJSON.getString("sub")).equals(json.getString("sub"))) {
                return CompletableFuture.failedFuture(new AuthenticationException("User subject does not match UserInfo subject"));
            }
            if (json.has("token")) {
                try {
                    this.verifyToken(json.getString("token"), false);
                }
                catch (IllegalStateException | TokenExpiredException ex) {
                    return CompletableFuture.failedFuture(ex);
                }
                catch (JwkException ex) {
                    return CompletableFuture.failedFuture(new AuthenticationException(ex.getMessage(), ex));
                }
            }
            return CompletableFuture.completedFuture(json);
        });
    }

    public CompletableFuture<Void> logout(@NotNull User user) {
        JSONObject authJSON = user.toJSON().getJSONObject("attributes").getJSONObject("auth");
        String accessToken = authJSON.getString("access_token");
        String refreshToken = authJSON.optString("refresh_token");
        return this.api.logout(accessToken, refreshToken);
    }

    private User createUser(@NotNull JSONObject json) throws JwkException, TokenExpiredException, IllegalStateException {
        JSONObject payload;
        String token;
        Objects.requireNonNull(json, "json can not be null");
        JSONObject userJSON = new JSONObject();
        JSONObject authJSON = new JSONObject(json.toString());
        if (json.has("access_token")) {
            token = json.getString("access_token");
            try {
                JSONObject verifiedAccessToken = this.verifyToken(token, false);
                authJSON.put("accessToken", (Object)verifiedAccessToken);
                payload = verifiedAccessToken.getJSONObject("payload");
                if (payload.has("name")) {
                    userJSON.put("name", (Object)payload.getString("name"));
                } else if (payload.has("email")) {
                    userJSON.put("name", (Object)payload.getString("email"));
                }
                authJSON.put("claimToken", (Object)"accessToken");
            }
            catch (JWTDecodeException | IllegalStateException ex) {
                logger.trace("Cannot decode access token:", ex);
            }
        }
        if (json.has("id_token")) {
            token = json.getString("id_token");
            try {
                JSONObject verifiedIdToken = this.verifyToken(token, true);
                authJSON.put("idToken", (Object)verifiedIdToken);
                payload = verifiedIdToken.getJSONObject("payload");
                if (payload.has("name")) {
                    userJSON.put("name", (Object)payload.getString("name"));
                } else if (payload.has("email")) {
                    userJSON.put("name", (Object)payload.getString("email"));
                }
            }
            catch (JWTDecodeException | IllegalStateException ex) {
                logger.trace("Cannot decode id token:", ex);
            }
        }
        userJSON.put("attributes", (Object)new JSONObject().put("auth", (Object)authJSON));
        return new User(userJSON);
    }

    private JSONObject verifyToken(String token, boolean idToken) throws JwkException, TokenExpiredException, IllegalStateException {
        List<String> audList;
        JSONArray audience;
        JSONObject json;
        JWTOptions jwtOptions;
        block22: {
            jwtOptions = this.options.getJWTOptions();
            try {
                DecodedJWT decodedToken = JWT.decode((String)token);
                if (this.options.isVerifyToken()) {
                    String alg = decodedToken.getAlgorithm();
                    Algorithm algorithm = Algorithm.none();
                    switch (alg) {
                        case "HS256": {
                            algorithm = Algorithm.HMAC256((String)this.options.getClientSecret());
                            break;
                        }
                        case "RS256": {
                            UrlJwkProvider jwkProvider;
                            try {
                                jwkProvider = new UrlJwkProvider(URI.create(this.options.getJwkPath()).toURL());
                            }
                            catch (MalformedURLException ex) {
                                throw new IllegalStateException("Invalid JWK path: " + this.options.getJwkPath());
                            }
                            Jwk jwk = jwkProvider.get(decodedToken.getKeyId());
                            algorithm = Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)jwk.getPublicKey()), null);
                        }
                    }
                    if (Algorithm.none().equals(algorithm)) {
                        throw new IllegalStateException("Algorithm \"none\" not allowed");
                    }
                    JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
                    DecodedJWT verifiedToken = verifier.verify(token);
                    json = this.jwtToJson(verifiedToken, idToken ? "id_token" : "access_token");
                    break block22;
                }
                json = this.jwtToJson(decodedToken, idToken ? "id_token" : "access_token");
            }
            catch (com.auth0.jwt.exceptions.TokenExpiredException tex) {
                throw new TokenExpiredException(tex.getMessage(), tex.getExpiredOn());
            }
        }
        if (json.has("aud")) {
            audience = json.getJSONArray("aud");
            if (audience == null || audience.isEmpty()) {
                throw new IllegalStateException("User audience is null or empty");
            }
            if (!audience.isEmpty() && !idToken && jwtOptions.getAudience() != null) {
                audList = audience.toList().stream().map(Object::toString).toList();
                for (String aud : jwtOptions.getAudience()) {
                    if (audList.contains(aud)) continue;
                    throw new IllegalStateException("Invalid JWT audience, expected: " + aud + ", actual: " + audience);
                }
            }
        }
        if (jwtOptions.getIssuer() != null && !jwtOptions.getIssuer().equals(json.getString("iss"))) {
            throw new IllegalStateException("Invalid JWT issuer, expected: " + jwtOptions.getIssuer() + ", actual: " + json.getString("iss"));
        }
        if (idToken && json.has("azp")) {
            if (!this.options.getClientId().equals(json.getString("azp"))) {
                throw new IllegalStateException("Invalid authorised party, expected: " + this.options.getClientId() + ", actual: " + json.getString("azp"));
            }
            audience = json.getJSONArray("aud");
            if (audience != null && audience.length() > 1 && (audList = audience.toList().stream().map(Object::toString).toList()).contains(json.getString("azp"))) {
                throw new IllegalStateException("ID token with multiple audiences, doesn't contain the azp Claim value");
            }
        }
        return json;
    }

    private JSONObject jwtToJson(DecodedJWT jwt, String tokenType) {
        JSONObject json = new JSONObject();
        json.put("token", (Object)jwt.getToken());
        json.put("token_type", (Object)tokenType);
        Optional.ofNullable(jwt.getHeader()).ifPresent(header -> {
            String decodedHeader = new String(BASE64_DECODER.decode((String)header));
            json.put("header", (Object)new JSONObject(decodedHeader));
        });
        Optional.ofNullable(jwt.getPayload()).ifPresent(payload -> {
            String decodedPayload = new String(BASE64_DECODER.decode((String)payload));
            json.put("payload", (Object)new JSONObject(decodedPayload));
        });
        Optional.ofNullable(jwt.getSignature()).ifPresent(signature -> json.put("signature", signature));
        Optional.ofNullable(jwt.getIssuer()).ifPresent(issuer -> json.put("iss", issuer));
        Optional.ofNullable(jwt.getSubject()).ifPresent(subject -> json.put("sub", subject));
        Optional.ofNullable(jwt.getAudience()).ifPresent(audience -> json.put("aud", (Object)new JSONArray((Collection)audience)));
        Optional.ofNullable(jwt.getExpiresAt()).map(Date::getTime).ifPresent(exp -> json.put("exp", exp));
        Optional.ofNullable(jwt.getIssuedAt()).map(Date::getTime).ifPresent(iat -> json.put("iat", iat));
        Optional.ofNullable(jwt.getNotBefore()).map(Date::getTime).ifPresent(nbr -> json.put("nbr", nbr));
        Optional.ofNullable(jwt.getId()).ifPresent(kid -> json.put("kid", kid));
        Optional.ofNullable(jwt.getClaim("azp")).ifPresent(azp -> json.put("azp", (Object)azp.asString()));
        Optional.ofNullable(jwt.getClaims()).ifPresent(claimMap -> json.put("claims", (Object)new JSONArray(claimMap.keySet())));
        return json;
    }

    private boolean hasExpired(User user) {
        JSONObject jwtInfo;
        if (user.getAttributes().containsKey("auth") && (jwtInfo = (JSONObject)user.getAttributes().get("auth")).has("exp")) {
            Instant expiredAt = Instant.ofEpochMilli(jwtInfo.getLong("exp"));
            return expiredAt.isBefore(Instant.now());
        }
        return false;
    }

    private String normalizeUri(String uri) {
        Object redirectUri = uri;
        if (this.httpServer != null && redirectUri != null && ((String)redirectUri).charAt(0) == '/') {
            int port = this.httpServer.getServerPort();
            Object server = this.httpServer.getServerHost();
            boolean isLocalAddress = ((String)server).equals("localhost");
            if (this.options.isUseLoopbackIpAddress() && isLocalAddress) {
                server = InetAddress.getLoopbackAddress().getHostAddress();
            }
            if (port > 0) {
                server = (String)server + ":" + port;
            }
            String serverUrl = isLocalAddress ? "http://" + (String)server : "https://" + (String)server;
            redirectUri = serverUrl + (String)redirectUri;
        }
        return redirectUri;
    }
}

