/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.oauth2.provider;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import javafx.stage.Stage;
import one.jpro.platform.auth.core.authentication.User;
import one.jpro.platform.auth.core.oauth2.OAuth2API;
import one.jpro.platform.auth.core.oauth2.OAuth2AuthenticationProvider;
import one.jpro.platform.auth.core.oauth2.OAuth2Credentials;
import one.jpro.platform.auth.core.oauth2.OAuth2Options;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenIDAuthenticationProvider
extends OAuth2AuthenticationProvider {
    private final OAuth2Credentials credentials = new OAuth2Credentials();

    protected OpenIDAuthenticationProvider(@Nullable Stage stage, @NotNull OAuth2API api) {
        super(stage, api);
        OAuth2Options options = api.getOptions();
        if (options.getSupportedScopes() != null && !options.getSupportedScopes().isEmpty()) {
            this.credentials.setScopes(options.getSupportedScopes());
        } else {
            this.credentials.setScopes(List.of("openid"));
        }
    }

    public OpenIDAuthenticationProvider(@Nullable Stage stage, @NotNull OAuth2Options options) {
        this(stage, new OAuth2API(options));
    }

    @NotNull
    public OAuth2Credentials getCredentials() {
        return this.credentials;
    }

    @NotNull
    public CompletableFuture<String> authorizeUrl() {
        return super.authorizeUrl(this.credentials);
    }

    @NotNull
    public CompletableFuture<User> authenticate() {
        return super.authenticate(this.credentials);
    }
}

