/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.authentication;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.jpro.platform.auth.core.authentication.User;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

public interface Authentication
extends Principal {
    public static final String KEY_NAME = "name";
    public static final String KEY_ROLES = "roles";
    public static final String KEY_ATTRIBUTES = "attributes";

    @NotNull
    public Map<String, Object> getAttributes();

    @NotNull
    default public Collection<String> getRoles() {
        return Collections.emptyList();
    }

    @NotNull
    default public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put(KEY_NAME, (Object)this.getName());
        json.put(KEY_ROLES, (Object)new JSONArray(this.getRoles()));
        json.put(KEY_ATTRIBUTES, (Object)new JSONObject(this.getAttributes()));
        return json;
    }

    @NotNull
    public static Authentication create(@NotNull String username) {
        return new User(username);
    }

    @NotNull
    public static Authentication create(@NotNull String username, @NotNull Set<String> roles) {
        Objects.requireNonNull(roles, "User's roles are null.");
        return new User(username, roles);
    }

    @NotNull
    public static Authentication create(@NotNull String username, @NotNull Map<String, Object> attributes) {
        Objects.requireNonNull(attributes, "User's attributes are null.");
        return new User(username, attributes);
    }

    @NotNull
    public static Authentication create(@NotNull String username, @Nullable Set<String> roles, @Nullable Map<String, Object> attributes) {
        return new User(username, roles, attributes);
    }

    @NotNull
    public static Authentication create(@NotNull JSONObject json) {
        return new User(json);
    }
}

