/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.basic;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import one.jpro.platform.auth.core.authentication.CredentialValidationException;
import one.jpro.platform.auth.core.authentication.User;
import one.jpro.platform.auth.core.basic.UserManager;
import one.jpro.platform.auth.core.basic.UserNotFoundException;
import one.jpro.platform.auth.core.basic.UsernamePasswordCredentials;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

public class InMemoryUserManager
implements UserManager {
    private final Map<String, User> users = new ConcurrentHashMap<String, User>();

    public InMemoryUserManager() {
    }

    public InMemoryUserManager(@NotNull Collection<User> users) {
        this();
        for (User user : users) {
            this.users.put(user.getName(), user);
        }
    }

    public InMemoryUserManager(User ... users) {
        this();
        for (User user : users) {
            this.users.put(user.getName(), user);
        }
    }

    @Override
    public CompletableFuture<User> createUser(@NotNull UsernamePasswordCredentials credentials, @Nullable Set<String> roles, @Nullable Map<String, Object> attributes) throws CredentialValidationException {
        Objects.requireNonNull(credentials, "Credentials cannot be null");
        credentials.validate(null);
        if (this.userExists(credentials.getUsername())) {
            throw new IllegalArgumentException("User already exists: " + credentials.getUsername());
        }
        return CompletableFuture.supplyAsync(() -> {
            JSONObject userJSON = new JSONObject();
            userJSON.put("name", (Object)credentials.getUsername());
            userJSON.put("roles", (Collection)roles);
            JSONObject credentialsJSON = credentials.toJSON();
            userJSON.put("attributes", (Object)new JSONObject(attributes).put("credentials", (Object)credentialsJSON));
            return new User(userJSON);
        }).thenApply(user -> {
            this.users.put(user.getName(), (User)user);
            return user;
        });
    }

    @Override
    public CompletableFuture<User> updateUser(@NotNull String username, @Nullable Set<String> roles, @Nullable Map<String, Object> attributes) throws UserNotFoundException, CredentialValidationException {
        if (!this.userExists(username)) {
            throw new UserNotFoundException("User does not exist: " + username);
        }
        return CompletableFuture.supplyAsync(() -> {
            User user = this.users.get(username);
            JSONObject userJSON = user.toJSON();
            JSONObject attributesJSON = new JSONObject(attributes);
            if (user.hasAttribute("credentials")) {
                JSONObject credentialsJSON = userJSON.getJSONObject("attributes").getJSONObject("credentials");
                attributesJSON.put("credentials", (Object)credentialsJSON);
            }
            return new User(username, roles, attributesJSON.toMap());
        }).thenApply(user -> {
            this.users.put(user.getName(), (User)user);
            return user;
        });
    }

    @Override
    public CompletableFuture<User> deleteUser(@Nullable String username) {
        return CompletableFuture.completedFuture(this.users.remove(username));
    }

    @Override
    public CompletableFuture<User> changePassword(@NotNull String username, @NotNull String newPassword) throws UserNotFoundException, CredentialValidationException {
        if (!this.userExists(username)) {
            throw new UserNotFoundException("User does not exist: " + username);
        }
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, newPassword);
        credentials.validate(null);
        return CompletableFuture.supplyAsync(() -> {
            User user = this.users.get(credentials.getUsername());
            JSONObject userJSON = user.toJSON();
            JSONObject credentialsJSON = credentials.toJSON();
            JSONObject attributesJSON = userJSON.getJSONObject("attributes");
            attributesJSON.put("credentials", (Object)credentialsJSON);
            if (attributesJSON.has("auth")) {
                attributesJSON.remove("auth");
            }
            return new User(userJSON);
        }).thenApply(user -> {
            this.users.put(user.getName(), (User)user);
            return user;
        });
    }

    @Override
    public boolean userExists(@Nullable String username) {
        return this.users.containsKey(username);
    }

    @Override
    public CompletableFuture<User> loadUserByUsername(@NotNull String username) throws UserNotFoundException {
        User user = this.users.get(username);
        if (user == null) {
            return CompletableFuture.failedFuture(new UserNotFoundException("User does not exist: " + username));
        }
        return CompletableFuture.completedFuture(this.users.get(username));
    }
}

