/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.basic.provider;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import one.jpro.platform.auth.core.authentication.AuthenticationException;
import one.jpro.platform.auth.core.authentication.AuthenticationProvider;
import one.jpro.platform.auth.core.authentication.CredentialValidationException;
import one.jpro.platform.auth.core.authentication.User;
import one.jpro.platform.auth.core.basic.UserManager;
import one.jpro.platform.auth.core.basic.UserNotFoundException;
import one.jpro.platform.auth.core.basic.UsernamePasswordCredentials;
import one.jpro.platform.auth.core.utils.AuthUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthenticationProvider
implements AuthenticationProvider<UsernamePasswordCredentials> {
    private static final Logger logger = LoggerFactory.getLogger(BasicAuthenticationProvider.class);
    public static final String DEFAULT_AUTHORIZATION_PATH = "/auth/basic";
    @NotNull
    private UserManager userManager;
    @NotNull
    private String authorizationPath = "/auth/basic";
    @Nullable
    private Set<String> roles;
    @Nullable
    private Map<String, Object> attributes;

    public BasicAuthenticationProvider(@NotNull UserManager userManager, @Nullable Set<String> roles, @Nullable Map<String, Object> attributes) {
        this.userManager = userManager;
        this.roles = roles;
        this.attributes = attributes;
    }

    @Override
    public CompletableFuture<User> authenticate(@NotNull UsernamePasswordCredentials credentials) throws AuthenticationException, CredentialValidationException {
        try {
            credentials.validate(null);
        }
        catch (CredentialValidationException ex) {
            logger.error("Username and password credentials not valid", (Throwable)ex);
            return CompletableFuture.failedFuture(ex);
        }
        return ((CompletableFuture)this.getUserManager().loadUserByUsername(credentials.getUsername()).thenCompose(user -> {
            JSONObject attributesJSON = user.toJSON().getJSONObject("attributes");
            if (attributesJSON.has("credentials")) {
                JSONObject credentialsJSON = attributesJSON.getJSONObject("credentials");
                String username = credentialsJSON.getString("username");
                String encodedPassword = credentialsJSON.getString("password");
                if (username.equals(credentials.getUsername()) && AuthUtils.BCRYPT_PASSWORD_ENCODER.matches(credentials.getPassword(), encodedPassword)) {
                    JSONObject authJSON = new JSONObject();
                    authJSON.put("type", (Object)"basic");
                    authJSON.put("username", (Object)username);
                    authJSON.put("password", (Object)encodedPassword);
                    JSONObject userJSON = user.toJSON();
                    userJSON.put("roles", this.roles);
                    userJSON.put("attributes", (Object)new JSONObject(this.attributes).put("auth", (Object)authJSON));
                    return CompletableFuture.completedFuture(new User(userJSON));
                }
                return CompletableFuture.failedFuture(new AuthenticationException("Invalid username or password"));
            }
            return CompletableFuture.failedFuture(new AuthenticationException("User has no credentials"));
        })).exceptionallyCompose(throwable -> {
            Throwable rootCause = throwable.getCause();
            if (rootCause instanceof UserNotFoundException) {
                return CompletableFuture.failedFuture(new AuthenticationException("Invalid username", rootCause));
            }
            return CompletableFuture.failedFuture(rootCause);
        });
    }

    @NotNull
    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(@NotNull UserManager userManager) {
        this.userManager = userManager;
    }

    @NotNull
    public String getAuthorizationPath() {
        return this.authorizationPath;
    }

    public void setAuthorizationPath(@NotNull String authorizationPath) {
        this.authorizationPath = authorizationPath;
    }

    @Nullable
    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(@Nullable Set<String> roles) {
        this.roles = roles;
    }

    @Nullable
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(@Nullable Map<String, Object> attributes) {
        this.attributes = attributes;
    }
}

