/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.http;

import com.jpro.webapi.WebAPI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.concurrent.CompletableFuture;
import javafx.stage.Stage;
import javafx.stage.Window;
import one.jpro.platform.auth.core.http.HttpOptions;
import one.jpro.platform.auth.core.http.HttpServerException;
import one.jpro.platform.auth.core.http.impl.HttpServerImpl;
import one.jpro.platform.auth.core.http.impl.JProServerImpl;
import one.jpro.platform.auth.core.utils.AuthUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface HttpServer
extends AutoCloseable {
    public static HttpServer create(@Nullable Stage stage) throws HttpServerException {
        if (WebAPI.isBrowser()) {
            Objects.requireNonNull(stage, "Stage cannot be null");
            WebAPI webAPI = WebAPI.getWebAPI((Window)stage);
            return new JProServerImpl(webAPI);
        }
        try {
            return new HttpServerImpl(stage, new HttpOptions().setReuseAddr(true).setReusePort(true));
        }
        catch (IOException ioe) {
            throw new HttpServerException(ioe);
        }
    }

    public void start();

    public void stop();

    @Override
    default public void close() {
        this.stop();
    }

    public String getServerHost();

    public int getServerPort();

    default public Map<String, String> getQueryParams() {
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, List<String>> params = this.getParameters();
        for (String key : params.keySet()) {
            result.put(key, params.get(key).get(0));
        }
        return result;
    }

    default public Map<String, List<String>> getParameters() {
        String uri = this.getFullRequestedURL();
        int qmi = uri.indexOf(63);
        return qmi >= 0 ? this.decodeParams(uri.substring(qmi + 1)) : Collections.emptyMap();
    }

    default public Map<String, List<String>> decodeParams(String queryParams) {
        AuthUtils.requireNonNullOrBlank(queryParams, "queryParams cannot be null or blank");
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        StringTokenizer st = new StringTokenizer(queryParams, "&");
        while (st.hasMoreTokens()) {
            String value;
            String key;
            String e = st.nextToken();
            int sep = e.indexOf(61);
            if (sep >= 0) {
                key = AuthUtils.decodePercent(e.substring(0, sep)).trim();
                value = AuthUtils.decodePercent(e.substring(sep + 1));
            } else {
                key = AuthUtils.decodePercent(e).trim();
                value = "";
            }
            List values = params.computeIfAbsent(key, k -> new ArrayList());
            values.add(value);
        }
        return params;
    }

    public String getFullRequestedURL();

    default public String getRequestedURL() {
        int idx = this.getFullRequestedURL().indexOf(63);
        if (idx != -1) {
            return this.getFullRequestedURL().substring(0, idx);
        }
        return this.getFullRequestedURL();
    }

    public CompletableFuture<String> openURL(@NotNull String var1);
}

