/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.basic;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import one.jpro.platform.auth.core.authentication.CredentialValidationException;
import one.jpro.platform.auth.core.authentication.Credentials;
import one.jpro.platform.auth.core.utils.AuthUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

public class UsernamePasswordCredentials
implements Credentials {
    private StringProperty username;
    private StringProperty password;

    public UsernamePasswordCredentials() {
    }

    public UsernamePasswordCredentials(@NotNull String username, @NotNull String password) {
        this.setUsername(username);
        this.setPassword(password);
    }

    @Nullable
    public String getUsername() {
        return this.username == null ? null : (String)this.username.get();
    }

    public void setUsername(@NotNull String username) {
        this.usernameProperty().set((Object)username);
    }

    @NotNull
    public final StringProperty usernameProperty() {
        if (this.username == null) {
            this.username = new SimpleStringProperty((Object)this, "username");
        }
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password == null ? null : (String)this.password.get();
    }

    public final void setPassword(@NotNull String password) {
        this.passwordProperty().set((Object)password);
    }

    @NotNull
    public final StringProperty passwordProperty() {
        if (this.password == null) {
            this.password = new SimpleStringProperty((Object)this, "password");
        }
        return this.password;
    }

    @Override
    public <V> void validate(V arg) throws CredentialValidationException {
        if (this.getUsername() == null || this.getUsername().isBlank()) {
            throw new CredentialValidationException("Username cannot be null or blank");
        }
        if (this.getPassword() == null) {
            throw new CredentialValidationException("Password cannot be null");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsernamePasswordCredentials that = (UsernamePasswordCredentials)o;
        return Objects.equals(this.getUsername(), that.getUsername()) && Objects.equals(this.getPassword(), that.getPassword());
    }

    public int hashCode() {
        return Objects.hash(this.getUsername(), this.getPassword());
    }

    @Override
    public String toHttpAuthorization() {
        StringBuilder result = new StringBuilder();
        String username = this.getUsername();
        if (username != null) {
            if (username.indexOf(58) != -1) {
                throw new IllegalArgumentException("Username cannot contain ':'");
            }
            result.append(username);
        }
        result.append(':');
        String password = this.getPassword();
        if (password != null) {
            result.append(password);
        }
        return "Basic " + AuthUtils.BASE64_ENCODER.encodeToString(result.toString().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        Optional.ofNullable(this.getUsername()).ifPresent(username -> json.put("username", username));
        Optional.ofNullable(this.getPassword()).ifPresent(password -> json.put("password", (Object)AuthUtils.BCRYPT_PASSWORD_ENCODER.encode((CharSequence)password)));
        return json;
    }
}

