/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.http;

import java.time.Duration;
import one.jpro.platform.auth.core.authentication.Options;
import org.json.JSONObject;

public class HttpOptions
implements Options {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 8080;
    public static final boolean DEFAULT_REUSE_ADDR = false;
    public static final boolean DEFAULT_REUSE_PORT = false;
    public static final Duration DEFAULT_RESOLUTION = Duration.ofMillis(100L);
    public static final Duration DEFAULT_REQUEST_TIMEOUT = Duration.ofSeconds(60L);
    public static final int DEFAULT_READ_BUFFER_SIZE = 65536;
    public static final int DEFAULT_ACCEPT_LENGTH = 0;
    public static final int DEFAULT_MAX_REQUEST_SIZE = 0x100000;
    public static final int DEFAULT_CONCURRENCY = Runtime.getRuntime().availableProcessors();
    private String host = "localhost";
    private int port = 8080;
    private boolean reuseAddr = false;
    private boolean reusePort = false;
    private Duration resolution = DEFAULT_RESOLUTION;
    private Duration requestTimeout = DEFAULT_REQUEST_TIMEOUT;
    private int readBufferSize = 65536;
    private int acceptLength = 0;
    private int maxRequestSize = 0x100000;
    private int concurrency = DEFAULT_CONCURRENCY;

    public String getHost() {
        return this.host;
    }

    public HttpOptions setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public HttpOptions setPort(int port) {
        this.port = port;
        return this;
    }

    public boolean isReuseAddr() {
        return this.reuseAddr;
    }

    public HttpOptions setReuseAddr(boolean reuseAddr) {
        this.reuseAddr = reuseAddr;
        return this;
    }

    public boolean isReusePort() {
        return this.reusePort;
    }

    public HttpOptions setReusePort(boolean reusePort) {
        this.reusePort = reusePort;
        return this;
    }

    public Duration getResolution() {
        return this.resolution;
    }

    public HttpOptions setResolution(Duration resolution) {
        this.resolution = resolution;
        return this;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public HttpOptions setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public HttpOptions setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
        return this;
    }

    public int getAcceptLength() {
        return this.acceptLength;
    }

    public HttpOptions setAcceptLength(int acceptLength) {
        this.acceptLength = acceptLength;
        return this;
    }

    public int getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public HttpOptions setMaxRequestSize(int maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
        return this;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public HttpOptions setConcurrency(int concurrency) {
        this.concurrency = concurrency;
        return this;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("host", (Object)this.host);
        json.put("port", this.port);
        json.put("reuseAddr", this.reuseAddr);
        json.put("reusePort", this.reusePort);
        json.put("resolution", this.resolution.toMillis());
        json.put("requestTimeout", this.requestTimeout.toMillis());
        json.put("readBufferSize", this.readBufferSize);
        json.put("acceptLength", this.acceptLength);
        json.put("maxRequestSize", this.maxRequestSize);
        json.put("concurrency", this.concurrency);
        return json;
    }
}

