/*
 * Decompiled with CFR 0.152.
 */
package one.jpro.platform.auth.core.http.impl;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import one.jpro.platform.auth.core.http.impl.Cancellable;
import one.jpro.platform.auth.core.http.impl.Clock;

final class Scheduler {
    private final Clock clock;
    private final SortedSet<Task> tasks;
    private long counter;

    Scheduler() {
        this(new SystemClock());
    }

    Scheduler(Clock clock) {
        this.clock = clock;
        this.tasks = new TreeSet<Task>(Comparator.comparing(t -> t.time).thenComparing(t -> t.id));
    }

    int size() {
        return this.tasks.size();
    }

    Cancellable schedule(Runnable task, Duration duration) {
        Task t = new Task(task, this.clock.nanoTime() + duration.toNanos(), this.counter++);
        this.tasks.add(t);
        return t;
    }

    List<Runnable> expired() {
        long time = this.clock.nanoTime();
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        Iterator it = this.tasks.iterator();
        while (it.hasNext()) {
            Task item = (Task)it.next();
            if (item.time > time) break;
            result.add(item.task);
            it.remove();
        }
        return result;
    }

    static class SystemClock
    implements Clock {
        SystemClock() {
        }

        @Override
        public long nanoTime() {
            return System.nanoTime();
        }
    }

    class Task
    implements Cancellable {
        final Runnable task;
        final long time;
        final long id;

        Task(Runnable task, long time, long id) {
            this.task = task;
            this.time = time;
            this.id = id;
        }

        @Override
        public void cancel() {
            Scheduler.this.tasks.remove(this);
        }
    }
}

